/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.util.LocationMapper;
import com.hp.hpl.jena.util.Locator;
import com.hp.hpl.jena.util.LocatorClassLoader;
import com.hp.hpl.jena.util.LocatorFile;
import com.hp.hpl.jena.util.LocatorURL;
import com.hp.hpl.jena.util.LocatorZip;
import com.hp.hpl.jena.util.TypedStream;
import java.util.Iterator;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.stream.LocatorHTTP;

class AdapterLib {
    AdapterLib() {
    }

    public static TypedStream convert(TypedInputStream in) {
        return new TypedStream(in, in.getContentType(), in.getCharset());
    }

    public static org.apache.jena.riot.system.stream.LocationMapper copyConvert(LocationMapper locMap) {
        org.apache.jena.riot.system.stream.LocationMapper lmap2 = new org.apache.jena.riot.system.stream.LocationMapper();
        if (locMap == null) {
            return null;
        }
        Iterator<String> sIter1 = locMap.listAltEntries();
        while (sIter1.hasNext()) {
            String k = sIter1.next();
            lmap2.addAltEntry(k, locMap.getAltEntry(k));
        }
        Iterator<String> sIter2 = locMap.listAltPrefixes();
        while (sIter2.hasNext()) {
            String k = sIter2.next();
            lmap2.addAltEntry(k, locMap.getAltPrefix(k));
        }
        return lmap2;
    }

    public static org.apache.jena.riot.system.stream.Locator convert(Locator oldloc) {
        if (oldloc instanceof LocatorFile) {
            LocatorFile lFile = (LocatorFile)oldloc;
            return new org.apache.jena.riot.system.stream.LocatorFile(lFile.getDir());
        }
        if (oldloc instanceof LocatorClassLoader) {
            LocatorClassLoader classLoc = (LocatorClassLoader)oldloc;
            return new org.apache.jena.riot.system.stream.LocatorClassLoader(classLoc.getClassLoader());
        }
        if (oldloc instanceof LocatorURL) {
            return new LocatorHTTP();
        }
        if (oldloc instanceof LocatorZip) {
            LocatorZip zipLoc = (LocatorZip)oldloc;
            return new org.apache.jena.riot.system.stream.LocatorZip(zipLoc.getZipFileName());
        }
        throw new RiotException("Unrecognized Locator: " + Utils.className(oldloc));
    }
}

