/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh.external;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.PermissionModeUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Streams;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.ssh.AbstractSshWagon;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class ScpExternalWagon
extends AbstractSshWagon {
    private String scpExecutable = "scp";
    private String sshExecutable = "ssh";
    private String scpArgs;
    private String sshArgs;
    private static final int SSH_FATAL_EXIT_CODE = 255;

    public void openConnection() throws AuthenticationException {
        super.openConnection();
    }

    public void closeConnection() {
    }

    public Streams executeCommand(String command, boolean ignoreFailures) throws CommandExecutionException {
        boolean putty = this.sshExecutable.indexOf("plink") >= 0;
        Commandline cl = this.createBaseCommandLine(putty, this.sshExecutable);
        int port = this.getPort();
        if (port != 22) {
            if (putty) {
                cl.createArgument().setLine("-P " + port);
            } else {
                cl.createArgument().setLine("-p " + port);
            }
        }
        if (this.sshArgs != null) {
            cl.createArgument().setLine(this.sshArgs);
        }
        String remoteHost = this.authenticationInfo.getUserName() + "@" + this.getRepository().getHost();
        cl.createArgument().setValue(remoteHost);
        cl.createArgument().setValue(command);
        this.fireSessionDebug("Executing command: " + cl.toString());
        try {
            CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
            CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
            int exitCode = CommandLineUtils.executeCommandLine(cl, out, err);
            Streams streams = new Streams();
            streams.setOut(out.getOutput());
            streams.setErr(err.getOutput());
            this.fireSessionDebug(streams.getOut());
            this.fireSessionDebug(streams.getErr());
            if (!(exitCode == 0 || ignoreFailures && exitCode != 255)) {
                throw new CommandExecutionException("Exit code " + exitCode + " - " + err.getOutput());
            }
            return streams;
        }
        catch (CommandLineException e2) {
            throw new CommandExecutionException("Error executing command line", e2);
        }
    }

    private Commandline createBaseCommandLine(boolean putty, String executable) {
        Commandline cl = new Commandline();
        cl.setExecutable(executable);
        File privateKey = this.getPrivateKey();
        if (privateKey != null) {
            cl.createArgument().setValue("-i");
            cl.createArgument().setFile(privateKey);
        }
        String password = this.authenticationInfo.getPassword();
        if (putty && password != null) {
            cl.createArgument().setValue("-pw");
            cl.createArgument().setValue(password);
        }
        if (putty) {
            cl.createArgument().setValue("-batch");
        } else {
            cl.createArgument().setValue("-o");
            cl.createArgument().setValue("BatchMode yes");
        }
        return cl;
    }

    private void executeScpCommand(File localFile, String remoteFile, boolean put) throws TransferFailedException, ResourceDoesNotExistException {
        boolean putty = this.scpExecutable.indexOf("pscp") >= 0;
        Commandline cl = this.createBaseCommandLine(putty, this.scpExecutable);
        cl.setWorkingDirectory(localFile.getParentFile().getAbsolutePath());
        int port = this.getPort();
        if (port != 22) {
            cl.createArgument().setLine("-P " + port);
        }
        if (this.scpArgs != null) {
            cl.createArgument().setLine(this.scpArgs);
        }
        String qualifiedRemoteFile = this.authenticationInfo.getUserName() + "@" + this.getRepository().getHost() + ":" + remoteFile;
        if (put) {
            cl.createArgument().setValue(localFile.getName());
            cl.createArgument().setValue(qualifiedRemoteFile);
        } else {
            cl.createArgument().setValue(qualifiedRemoteFile);
            cl.createArgument().setValue(localFile.getName());
        }
        this.fireSessionDebug("Executing command: " + cl.toString());
        try {
            CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
            int exitCode = CommandLineUtils.executeCommandLine(cl, null, err);
            if (exitCode != 0) {
                if (!put && err.getOutput().trim().toLowerCase().endsWith("no such file or directory")) {
                    throw new ResourceDoesNotExistException(err.getOutput());
                }
                throw new TransferFailedException("Exit code: " + exitCode + " - " + err.getOutput());
            }
        }
        catch (CommandLineException e2) {
            throw new TransferFailedException("Error executing command line", e2);
        }
    }

    public void put(File source, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String dirPerms;
        Resource resource = new Resource(destination);
        this.firePutInitiated(resource, source);
        if (!source.exists()) {
            throw new TransferFailedException("Specified source file does not exist: " + source);
        }
        String basedir = this.getRepository().getBasedir();
        String resourceName = StringUtils.replace(destination, "\\", "/");
        String dir = PathUtils.dirname(resourceName);
        dir = StringUtils.replace(dir, "\\", "/");
        String umaskCmd = null;
        if (this.getRepository().getPermissions() != null && (dirPerms = this.getRepository().getPermissions().getDirectoryMode()) != null) {
            umaskCmd = "umask " + PermissionModeUtils.getUserMaskFor(dirPerms);
        }
        String mkdirCmd = "mkdir -p " + basedir + "/" + dir + "\n";
        if (umaskCmd != null) {
            mkdirCmd = umaskCmd + "; " + mkdirCmd;
        }
        try {
            this.executeCommand(mkdirCmd);
        }
        catch (CommandExecutionException e2) {
            throw new TransferFailedException("Error executing command for transfer", e2);
        }
        this.firePutStarted(resource, source);
        this.executeScpCommand(source, basedir + "/" + resourceName, true);
        this.postProcessListeners(resource, source, 6);
        try {
            RepositoryPermissions permissions = this.getRepository().getPermissions();
            if (permissions != null && permissions.getGroup() != null) {
                this.executeCommand("chgrp -f " + permissions.getGroup() + " " + basedir + "/" + resourceName + "\n", true);
            }
            String fileMode = "644";
            if (permissions != null && permissions.getFileMode() != null) {
                fileMode = permissions.getFileMode();
            }
            this.executeCommand("chmod -f " + fileMode + " " + basedir + "/" + resourceName + "\n", true);
        }
        catch (CommandExecutionException e3) {
            throw new TransferFailedException("Error executing command for transfer", e3);
        }
        this.firePutCompleted(resource, source);
    }

    public void executeCommand(String command) throws CommandExecutionException {
        this.executeCommand(command, false);
    }

    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String basedir = this.getRepository().getBasedir();
        String path = StringUtils.replace(resourceName, "\\", "/");
        this.createParentDirectories(destination);
        Resource resource = new Resource(path);
        this.fireGetStarted(resource, destination);
        this.executeScpCommand(destination, basedir + "/" + path, false);
        this.postProcessListeners(resource, destination, 5);
        this.fireGetCompleted(resource, destination);
    }

    public String getScpExecutable() {
        return this.scpExecutable;
    }

    public void setScpExecutable(String scpExecutable) {
        this.scpExecutable = scpExecutable;
    }

    public String getSshExecutable() {
        return this.sshExecutable;
    }

    public void setSshExecutable(String sshExecutable) {
        this.sshExecutable = sshExecutable;
    }

    public String getScpArgs() {
        return this.scpArgs;
    }

    public void setScpArgs(String scpArgs) {
        this.scpArgs = scpArgs;
    }

    public String getSshArgs() {
        return this.sshArgs;
    }

    public void setSshArgs(String sshArgs) {
        this.sshArgs = sshArgs;
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        File zipFile;
        String basedir = this.getRepository().getBasedir();
        String dir = StringUtils.replace(destinationDirectory, "\\", "/");
        String path = AbstractWagon.getPath(basedir, dir);
        try {
            String dirPerms;
            if (this.getRepository().getPermissions() != null && (dirPerms = this.getRepository().getPermissions().getDirectoryMode()) != null) {
                String umaskCmd = "umask " + PermissionModeUtils.getUserMaskFor(dirPerms);
                this.executeCommand(umaskCmd);
            }
            String mkdirCmd = "mkdir -p " + path;
            this.executeCommand(mkdirCmd);
        }
        catch (CommandExecutionException e2) {
            throw new TransferFailedException("Error performing commands for file transfer", e2);
        }
        try {
            zipFile = File.createTempFile("wagon", ".zip");
            zipFile.deleteOnExit();
            List files = FileUtils.getFileNames(sourceDirectory, "**/**", "", false);
            this.createZip(files, zipFile, sourceDirectory);
        }
        catch (IOException e3) {
            throw new TransferFailedException("Unable to create ZIP archive of directory", e3);
        }
        this.put(zipFile, AbstractWagon.getPath(dir, zipFile.getName()));
        try {
            this.executeCommand("cd " + path + "; unzip -o " + zipFile.getName() + "; rm -f " + zipFile.getName());
            zipFile.delete();
            RepositoryPermissions permissions = this.getRepository().getPermissions();
            if (permissions != null && permissions.getGroup() != null) {
                this.executeCommand("chgrp -Rf " + permissions.getGroup() + " " + path);
            }
            if (permissions != null && permissions.getFileMode() != null) {
                this.executeCommand("chmod -Rf " + permissions.getFileMode() + " " + path);
            }
        }
        catch (CommandExecutionException e4) {
            throw new TransferFailedException("Error performing commands for file transfer", e4);
        }
    }
}

