/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.response.DocumentAnalysisResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ContentStream;

public class DocumentAnalysisRequest
extends SolrRequest<DocumentAnalysisResponse> {
    private List<SolrInputDocument> documents = new ArrayList<SolrInputDocument>();
    private String query;
    private boolean showMatch = false;

    public DocumentAnalysisRequest() {
        super(SolrRequest.METHOD.POST, "/analysis/document");
    }

    public DocumentAnalysisRequest(String uri) {
        super(SolrRequest.METHOD.POST, uri);
    }

    @Override
    public Collection<ContentStream> getContentStreams() throws IOException {
        return ClientUtils.toContentStreams(this.getXML(), "application/xml; charset=UTF-8");
    }

    @Override
    protected DocumentAnalysisResponse createResponse(SolrClient client) {
        return new DocumentAnalysisResponse();
    }

    @Override
    public ModifiableSolrParams getParams() {
        ModifiableSolrParams params = new ModifiableSolrParams();
        if (this.query != null) {
            params.add("analysis.query", this.query);
            params.add("analysis.showmatch", String.valueOf(this.showMatch));
        }
        return params;
    }

    String getXML() throws IOException {
        StringWriter writer = new StringWriter();
        writer.write("<docs>");
        for (SolrInputDocument document : this.documents) {
            ClientUtils.writeXML(document, writer);
        }
        writer.write("</docs>");
        writer.flush();
        String xml = writer.toString();
        return xml.length() > 0 ? xml : null;
    }

    public DocumentAnalysisRequest addDocument(SolrInputDocument doc) {
        this.documents.add(doc);
        return this;
    }

    public DocumentAnalysisRequest addDocuments(Collection<SolrInputDocument> docs) {
        this.documents.addAll(docs);
        return this;
    }

    public DocumentAnalysisRequest setQuery(String query2) {
        this.query = query2;
        return this;
    }

    public DocumentAnalysisRequest setShowMatch(boolean showMatch) {
        this.showMatch = showMatch;
        return this;
    }

    public List<SolrInputDocument> getDocuments() {
        return this.documents;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean isShowMatch() {
        return this.showMatch;
    }
}

