/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class Os {
    public static final String FAMILY_DOS = "dos";
    public static final String FAMILY_MAC = "mac";
    public static final String FAMILY_NETWARE = "netware";
    public static final String FAMILY_OS2 = "os/2";
    public static final String FAMILY_TANDEM = "tandem";
    public static final String FAMILY_UNIX = "unix";
    public static final String FAMILY_WINDOWS = "windows";
    public static final String FAMILY_WIN9X = "win9x";
    public static final String FAMILY_ZOS = "z/os";
    public static final String FAMILY_OS400 = "os/400";
    public static final String FAMILY_OPENVMS = "openvms";
    private static final Set validFamilies = Os.setValidFamilies();
    private static final String PATH_SEP = System.getProperty("path.separator");
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    public static final String OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.US);
    public static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.US);
    public static final String OS_FAMILY = Os.getOsFamily();
    private String family;
    private String name;
    private String version;
    private String arch;

    public Os() {
    }

    public Os(String family) {
        this.setFamily(family);
    }

    private static Set setValidFamilies() {
        HashSet<String> valid = new HashSet<String>();
        valid.add(FAMILY_DOS);
        valid.add(FAMILY_MAC);
        valid.add(FAMILY_NETWARE);
        valid.add(FAMILY_OS2);
        valid.add(FAMILY_TANDEM);
        valid.add(FAMILY_UNIX);
        valid.add(FAMILY_WINDOWS);
        valid.add(FAMILY_WIN9X);
        valid.add(FAMILY_ZOS);
        valid.add(FAMILY_OS400);
        valid.add(FAMILY_OPENVMS);
        return valid;
    }

    public void setFamily(String f) {
        this.family = f.toLowerCase(Locale.US);
    }

    public void setName(String name) {
        this.name = name.toLowerCase(Locale.US);
    }

    public void setArch(String arch) {
        this.arch = arch.toLowerCase(Locale.US);
    }

    public void setVersion(String version2) {
        this.version = version2.toLowerCase(Locale.US);
    }

    public boolean eval() throws Exception {
        return Os.isOs(this.family, this.name, this.arch, this.version);
    }

    public static boolean isFamily(String family) {
        return Os.isOs(family, null, null, null);
    }

    public static boolean isName(String name) {
        return Os.isOs(null, name, null, null);
    }

    public static boolean isArch(String arch) {
        return Os.isOs(null, null, arch, null);
    }

    public static boolean isVersion(String version2) {
        return Os.isOs(null, null, null, version2);
    }

    public static boolean isOs(String family, String name, String arch, String version2) {
        boolean retValue = false;
        if (family != null || name != null || arch != null || version2 != null) {
            boolean isFamily = true;
            boolean isName = true;
            boolean isArch = true;
            boolean isVersion = true;
            if (family != null) {
                if (family.equalsIgnoreCase(FAMILY_WINDOWS)) {
                    isFamily = OS_NAME.indexOf(FAMILY_WINDOWS) > -1;
                } else if (family.equalsIgnoreCase(FAMILY_OS2)) {
                    isFamily = OS_NAME.indexOf(FAMILY_OS2) > -1;
                } else if (family.equalsIgnoreCase(FAMILY_NETWARE)) {
                    isFamily = OS_NAME.indexOf(FAMILY_NETWARE) > -1;
                } else if (family.equalsIgnoreCase(FAMILY_DOS)) {
                    isFamily = PATH_SEP.equals(";") && !Os.isFamily(FAMILY_NETWARE);
                } else if (family.equalsIgnoreCase(FAMILY_MAC)) {
                    isFamily = OS_NAME.indexOf(FAMILY_MAC) > -1;
                } else if (family.equalsIgnoreCase(FAMILY_TANDEM)) {
                    isFamily = OS_NAME.indexOf("nonstop_kernel") > -1;
                } else if (family.equalsIgnoreCase(FAMILY_UNIX)) {
                    isFamily = PATH_SEP.equals(":") && !Os.isFamily(FAMILY_OPENVMS) && (!Os.isFamily(FAMILY_MAC) || OS_NAME.endsWith("x"));
                } else if (family.equalsIgnoreCase(FAMILY_WIN9X)) {
                    isFamily = Os.isFamily(FAMILY_WINDOWS) && (OS_NAME.indexOf("95") >= 0 || OS_NAME.indexOf("98") >= 0 || OS_NAME.indexOf("me") >= 0 || OS_NAME.indexOf("ce") >= 0);
                } else if (family.equalsIgnoreCase(FAMILY_ZOS)) {
                    isFamily = OS_NAME.indexOf(FAMILY_ZOS) > -1 || OS_NAME.indexOf("os/390") > -1;
                } else if (family.equalsIgnoreCase(FAMILY_OS400)) {
                    isFamily = OS_NAME.indexOf(FAMILY_OS400) > -1;
                } else if (family.equalsIgnoreCase(FAMILY_OPENVMS)) {
                    isFamily = OS_NAME.indexOf(FAMILY_OPENVMS) > -1;
                } else {
                    boolean bl = isFamily = OS_NAME.indexOf(family.toLowerCase(Locale.US)) > -1;
                }
            }
            if (name != null) {
                isName = name.toLowerCase(Locale.US).equals(OS_NAME);
            }
            if (arch != null) {
                isArch = arch.toLowerCase(Locale.US).equals(OS_ARCH);
            }
            if (version2 != null) {
                isVersion = version2.toLowerCase(Locale.US).equals(OS_VERSION);
            }
            retValue = isFamily && isName && isArch && isVersion;
        }
        return retValue;
    }

    private static String getOsFamily() {
        Set families = null;
        families = !validFamilies.isEmpty() ? validFamilies : Os.setValidFamilies();
        Iterator iter = families.iterator();
        while (iter.hasNext()) {
            String fam = (String)iter.next();
            if (!Os.isFamily(fam)) continue;
            return fam;
        }
        return null;
    }

    public static boolean isValidFamily(String theFamily) {
        return validFamilies.contains(theFamily);
    }

    public static Set getValidFamilies() {
        return new HashSet(validFamilies);
    }
}

