/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.lang3.StringUtils;
import org.dataone.cn.indexer.parser.IDocumentDeleteSubprocessor;
import org.dataone.cn.indexer.solrhttp.HTTPService;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseDocumentDeleteSubprocessor
implements IDocumentDeleteSubprocessor {
    @Autowired
    private HTTPService httpService;
    @Autowired
    private String solrQueryUri;
    private String relationSourceFormatId;
    private String relationSourceField;
    private List<String> biDirectionalRelationFields;
    private List<String> uniDirectionalRelationFields;

    @Override
    public Map<String, SolrDoc> processDocForDelete(String identifier, Map<String, SolrDoc> docs) throws Exception {
        SolrDoc indexedDoc = this.httpService.retrieveDocumentFromSolrServer(identifier, this.solrQueryUri);
        if (indexedDoc != null) {
            if (this.hasRelationsBySource(indexedDoc)) {
                docs.putAll(this.removeBiDirectionalRelationsForDoc(identifier, indexedDoc, docs));
            }
            if (this.isRelationshipSource(indexedDoc)) {
                docs.putAll(this.removeRelationsBySourceDoc(identifier, indexedDoc, docs));
            }
        }
        return docs;
    }

    private Map<String, SolrDoc> removeRelationsBySourceDoc(String relationSourceId, SolrDoc indexedDoc, Map<String, SolrDoc> docs) throws Exception {
        List<SolrDoc> relatedDocs = this.httpService.getDocumentsByField(this.solrQueryUri, Collections.singletonList(relationSourceId), this.relationSourceField, true);
        HashSet<String> otherSourceDocs = new HashSet<String>();
        for (SolrDoc relatedDoc : relatedDocs) {
            otherSourceDocs.addAll(relatedDoc.getAllFieldValues(this.relationSourceField));
            String docId = relatedDoc.getFirstFieldValue("id");
            if (docs.get(docId) != null) {
                relatedDoc = docs.get(docId);
            }
            relatedDoc.removeAllFields(this.relationSourceField);
            for (String relationField : this.getBiDirectionalRelationFields()) {
                relatedDoc.removeAllFields(relationField);
            }
            for (String relationField : this.getUniDirectionalRelationFields()) {
                relatedDoc.removeAllFields(relationField);
            }
            docs.put(docId, relatedDoc);
        }
        for (String otherRelatedDoc : otherSourceDocs) {
            if (otherRelatedDoc.equals(relationSourceId)) continue;
            docs.put(otherRelatedDoc, null);
        }
        return docs;
    }

    private boolean isRelationshipSource(SolrDoc indexedDoc) throws Exception {
        String formatId = indexedDoc.getFirstFieldValue("formatId");
        return this.relationSourceFormatId.equals(formatId);
    }

    private boolean hasRelationsBySource(SolrDoc indexedDoc) throws XPathExpressionException, IOException, EncoderException {
        String relationSourceId = indexedDoc.getFirstFieldValue(this.relationSourceField);
        return StringUtils.isNotEmpty(relationSourceId);
    }

    private Map<String, SolrDoc> removeBiDirectionalRelationsForDoc(String identifier, SolrDoc indexedDoc, Map<String, SolrDoc> docs) throws Exception {
        for (String relationField : this.getBiDirectionalRelationFields()) {
            List<SolrDoc> inverseDocs = this.httpService.getDocumentsByField(this.solrQueryUri, Collections.singletonList(identifier), relationField, true);
            for (SolrDoc inverseDoc : inverseDocs) {
                String inverseDocId = inverseDoc.getFirstFieldValue("id");
                if (docs.get(inverseDocId) != null) {
                    inverseDoc = docs.get(inverseDocId);
                }
                inverseDoc.removeFieldsWithValue(relationField, identifier);
                docs.put(inverseDocId, inverseDoc);
            }
        }
        return docs;
    }

    private List<String> getBiDirectionalRelationFields() {
        if (this.biDirectionalRelationFields == null) {
            this.biDirectionalRelationFields = new ArrayList<String>();
        }
        return this.biDirectionalRelationFields;
    }

    private List<String> getUniDirectionalRelationFields() {
        if (this.uniDirectionalRelationFields == null) {
            this.uniDirectionalRelationFields = new ArrayList<String>();
        }
        return this.uniDirectionalRelationFields;
    }

    public String getRelationSourceFormatId() {
        return this.relationSourceFormatId;
    }

    public void setRelationSourceFormatId(String relationSourceFormatId) {
        this.relationSourceFormatId = relationSourceFormatId;
    }

    public String getRelationSourceField() {
        return this.relationSourceField;
    }

    public void setRelationSourceField(String relationSourceField) {
        this.relationSourceField = relationSourceField;
    }

    public void setBiDirectionalRelationFields(List<String> biDirectionalRelationFields) {
        this.biDirectionalRelationFields = biDirectionalRelationFields;
    }

    public void setUniDirectionalRelationFields(List<String> uniDirectionalRelationFields) {
        this.uniDirectionalRelationFields = uniDirectionalRelationFields;
    }
}

