/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.RollbackException;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.ejb.AbstractEntityManagerImpl;
import org.hibernate.ejb.HibernateEntityManagerImplementor;

public class TransactionImpl
implements EntityTransaction {
    private HibernateEntityManagerImplementor entityManager;
    private Transaction tx;
    private boolean rollbackOnly;

    public TransactionImpl(AbstractEntityManagerImpl entityManager) {
        this.entityManager = entityManager;
    }

    private Session getSession() {
        return this.entityManager.getSession();
    }

    public void begin() {
        try {
            this.rollbackOnly = false;
            if (this.tx != null && this.tx.isActive()) {
                throw new IllegalStateException("Transaction already active");
            }
            this.tx = this.getSession().beginTransaction();
        }
        catch (HibernateException he) {
            this.entityManager.throwPersistenceException(he);
        }
    }

    public void commit() {
        if (this.tx == null || !this.tx.isActive()) {
            throw new IllegalStateException("Transaction not active");
        }
        if (this.rollbackOnly) {
            this.tx.rollback();
            throw new RollbackException("Transaction marked as rollbackOnly");
        }
        try {
            this.tx.commit();
        }
        catch (Exception e2) {
            Exception wrappedException = e2 instanceof HibernateException ? this.entityManager.convert((HibernateException)e2) : e2;
            try {
                this.tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RollbackException("Error while committing the transaction", wrappedException);
        }
        finally {
            this.rollbackOnly = false;
        }
    }

    public void rollback() {
        if (this.tx == null || !this.tx.isActive()) {
            throw new IllegalStateException("Transaction not active");
        }
        try {
            this.tx.rollback();
        }
        catch (Exception e2) {
            throw new PersistenceException("unexpected error when rollbacking", e2);
        }
        finally {
            try {
                Session session;
                if (this.entityManager != null && (session = this.getSession()) != null && session.isOpen()) {
                    session.clear();
                }
            }
            catch (Throwable throwable) {}
            this.rollbackOnly = false;
        }
    }

    public void setRollbackOnly() {
        if (!this.isActive()) {
            throw new IllegalStateException("Transaction not active");
        }
        this.rollbackOnly = true;
    }

    public boolean getRollbackOnly() {
        if (!this.isActive()) {
            throw new IllegalStateException("Transaction not active");
        }
        return this.rollbackOnly;
    }

    public boolean isActive() {
        try {
            return this.tx != null && this.tx.isActive();
        }
        catch (RuntimeException e2) {
            throw new PersistenceException("unexpected error when checking transaction status", e2);
        }
    }
}

