/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.IOUtil;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.client.QueueItemIterator;
import com.hazelcast.client.impl.QueueItemListenerManager;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.Instance;
import com.hazelcast.core.ItemListener;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.Keys;
import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.nio.Data;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueClientProxy<E>
extends AbstractQueue<E>
implements IQueue<E> {
    protected final ProxyHelper proxyHelper;
    protected final String name;
    final Object lock = new Object();

    public QueueClientProxy(HazelcastClient hazelcastClient, String name) {
        this.name = name;
        this.proxyHelper = new ProxyHelper(name, hazelcastClient);
    }

    @Override
    public String getName() {
        return this.name.substring("q:".length());
    }

    @Override
    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.QUEUE;
    }

    @Override
    public void destroy() {
        this.proxyHelper.destroy();
    }

    @Override
    public Object getId() {
        return this.name;
    }

    @Override
    public String toString() {
        return "Queue{name='" + this.name + '\'' + '}';
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public LocalQueueStats getLocalQueueStats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e2) {
        ProxyHelper.check(e2);
        return this.innerOffer(e2, 0L);
    }

    @Override
    public E poll() {
        return this.innerPoll(0L);
    }

    @Override
    public E peek() {
        return (E)this.proxyHelper.doOp(ClusterOperation.BLOCKING_QUEUE_PEEK, null, null);
    }

    @Override
    public boolean offer(E e2, long l, TimeUnit timeUnit) throws InterruptedException {
        ProxyHelper.check(e2);
        ProxyHelper.checkTime(l, timeUnit);
        long l2 = l = l < 0L ? 0L : l;
        if (e2 == null) {
            throw new NullPointerException();
        }
        return this.innerOffer(e2, timeUnit.toMillis(l));
    }

    private boolean innerOffer(E e2, long millis) {
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.BLOCKING_QUEUE_OFFER, e2, millis);
    }

    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        ProxyHelper.checkTime(l, timeUnit);
        l = l < 0L ? 0L : l;
        return this.innerPoll(timeUnit.toMillis(l));
    }

    private E innerPoll(long millis) {
        return (E)this.proxyHelper.doOp(ClusterOperation.BLOCKING_QUEUE_POLL, null, millis);
    }

    @Override
    public E take() throws InterruptedException {
        return this.innerPoll(-1L);
    }

    @Override
    public void put(E e2) throws InterruptedException {
        ProxyHelper.check(e2);
        this.innerOffer(e2, -1L);
    }

    @Override
    public int remainingCapacity() {
        return (Integer)this.proxyHelper.doOp(ClusterOperation.BLOCKING_QUEUE_REMAINING_CAPACITY, null, null);
    }

    @Override
    public int drainTo(Collection<? super E> objects) {
        return this.drainTo(objects, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super E> objects, int i) {
        E e2;
        int counter;
        if (objects == null) {
            throw new NullPointerException("drainTo null!");
        }
        if (i < 0) {
            throw new IllegalArgumentException("Negative maxElements:" + i);
        }
        if (i == 0) {
            return 0;
        }
        if (objects instanceof IQueue && ((IQueue)objects).getName().equals(this.getName())) {
            throw new IllegalArgumentException("Cannot drainTo self!");
        }
        for (counter = 0; counter < i && (e2 = this.poll()) != null; ++counter) {
            objects.add(e2);
        }
        return counter;
    }

    @Override
    public int size() {
        return (Integer)this.proxyHelper.doOp(ClusterOperation.BLOCKING_QUEUE_SIZE, null, null);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof IQueue && o != null) {
            return this.getName().equals(((IQueue)o).getName());
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.BLOCKING_QUEUE_REMOVE, null, o);
    }

    @Override
    public Iterator<E> iterator() {
        Keys keys = (Keys)this.proxyHelper.doOp(ClusterOperation.BLOCKING_QUEUE_ENTRIES, null, null);
        ArrayList<Object> list = new ArrayList<Object>();
        for (Data d : keys) {
            list.add(IOUtil.toObject(d.buffer));
        }
        return new QueueItemIterator<Object>(list.toArray(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addItemListener(ItemListener<E> listener, boolean includeValue) {
        ProxyHelper.check(listener);
        Object object = this.lock;
        synchronized (object) {
            boolean shouldCall = this.listenerManager().noListenerRegistered(this.name);
            this.listenerManager().registerListener(this.name, listener, includeValue);
            if (shouldCall) {
                Call c = this.listenerManager().createNewAddItemListenerCall(this.proxyHelper, includeValue);
                this.proxyHelper.doCall(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeItemListener(ItemListener<E> listener) {
        ProxyHelper.check(listener);
        Object object = this.lock;
        synchronized (object) {
            this.listenerManager().removeListener(this.name, listener);
            Packet request = this.proxyHelper.createRequestPacket(ClusterOperation.REMOVE_LISTENER, null, null);
            Call c = this.proxyHelper.createCall(request);
            this.proxyHelper.doCall(c);
        }
    }

    private QueueItemListenerManager listenerManager() {
        return this.proxyHelper.getHazelcastClient().getListenerManager().getQueueItemListenerManager();
    }
}

