/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.examples;

import com.hazelcast.client.ClientConfig;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.examples.TestApp;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class TestClientApp {
    HazelcastClient hz;
    TestApp app;

    public static void main(String[] arguments) {
        TestClientApp app = new TestClientApp();
        if (arguments.length == 0) {
            app.noArgument();
        } else {
            try {
                app.connect(arguments);
                app.run(arguments);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public void noArgument() {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        this.message();
        while (true) {
            System.out.print("client > ");
            try {
                String command = in.readLine();
                String[] argsSplit = command.split(" ");
                String[] args = new String[argsSplit.length];
                for (int i = 0; i < argsSplit.length; ++i) {
                    args[i] = argsSplit[i].trim();
                }
                this.handleCommand(args);
                this.run(args);
                continue;
            }
            catch (Throwable e2) {
                e2.printStackTrace();
                continue;
            }
            break;
        }
    }

    void run(String[] args) throws Exception {
        if (this.hz != null) {
            this.app = new TestApp(this.hz);
            this.app.start(null);
        }
    }

    private void handleCommand(String[] args) throws Exception {
        if (args[0].startsWith("connect")) {
            this.connect(TestClientApp.copyOfRange(args, 1, args.length));
        } else {
            if (this.hz == null) {
                this.message();
                return;
            }
            System.out.println("Unknown command. Sample commands:");
            System.out.println("connect 192.168.1.3");
        }
    }

    private static String[] copyOfRange(String[] original, int from, int to) {
        int length = to - from;
        if (length < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        String[] copy = new String[length];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, length));
        return copy;
    }

    private void message() {
        System.out.println("Make sure you started Hazelcast server first.");
        System.out.println("You should connect first by typing 'connect <hazelcast-server-ip> <group-name> <group-password>'");
        System.out.println("If group-name is 'dev' and password is 'dev-pass', 'connect <hazelcast-server-ip>' will be enough ");
    }

    private void connect(String[] args) {
        String ip = "localhost";
        String groupName = "dev";
        String pass = "dev-pass";
        if (args.length > 0) {
            ip = args[0];
        }
        if (args.length > 2) {
            groupName = args[1];
            pass = args[2];
        }
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setGroupConfig(new GroupConfig(groupName, pass));
        System.out.println("Connecting to " + ip);
        String[] ips = null;
        ips = ip.indexOf(58) == -1 ? new String[]{ip + ":5701", ip + ":5702", ip + ":5703"} : new String[]{ip};
        clientConfig.addAddress(ips);
        this.hz = HazelcastClient.newHazelcastClient(clientConfig);
        System.out.println(this.hz.getCluster().getMembers());
    }
}

