/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.impl.management.ConsoleRequest;
import com.hazelcast.impl.management.ManagementCenterService;
import com.hazelcast.impl.management.ScriptExecutorCallable;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.SerializationHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteScriptRequest
implements ConsoleRequest {
    private static final byte NULL = 0;
    private static final byte MAP = 1;
    private static final byte COLLECTION = 2;
    private static final byte OTHER = -1;
    private String script;
    private String engine;
    private Set<Address> targets;
    private boolean targetAllMembers = false;
    private Map<String, Object> bindings;

    public ExecuteScriptRequest() {
    }

    public ExecuteScriptRequest(String script, String engine, boolean targetAllMembers, Map<String, Object> bindings) {
        this.script = script;
        this.engine = engine;
        this.targets = new HashSet<Address>(0);
        this.targetAllMembers = targetAllMembers;
        this.bindings = bindings;
    }

    public ExecuteScriptRequest(String script, String engine, Set<Address> targets, Map<String, Object> bindings) {
        this.script = script;
        this.targets = targets;
        this.engine = engine;
        this.targetAllMembers = false;
        this.bindings = bindings;
    }

    @Override
    public int getType() {
        return 3;
    }

    public Set<Address> getTargets() {
        return this.targets;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, DataOutput dos) throws Exception {
        Object result = null;
        ScriptExecutorCallable callable = new ScriptExecutorCallable(this.engine, this.script);
        callable.setHazelcastInstance(mcs.getHazelcastInstance());
        callable.setBindings(this.bindings);
        result = this.targetAllMembers ? mcs.callOnAllMembers(callable) : (this.targets.isEmpty() ? mcs.call(callable) : (this.targets.size() == 1 ? mcs.call(this.targets.iterator().next(), callable) : mcs.callOnMembers(this.targets, callable)));
        if (result != null) {
            if (result instanceof Map) {
                dos.writeByte(1);
                this.writeMap(dos, (Map)result);
            } else if (result instanceof Collection) {
                dos.writeByte(2);
                this.writeCollection(dos, (Collection)result);
            } else {
                dos.writeByte(-1);
                SerializationHelper.writeObject(dos, result);
            }
        } else {
            dos.writeByte(0);
        }
    }

    @Override
    public Object readResponse(DataInput in) throws IOException {
        byte flag = in.readByte();
        switch (flag) {
            case 1: {
                return this.readMap(in);
            }
            case 2: {
                return this.readCollection(in);
            }
            case -1: {
                return SerializationHelper.readObject(in);
            }
        }
        return null;
    }

    private void writeMap(DataOutput dos, Map result) throws IOException {
        int size = result != null ? result.size() : 0;
        dos.writeInt(size);
        if (size > 0) {
            Set entries = result.entrySet();
            for (Map.Entry entry : entries) {
                SerializationHelper.writeObject(dos, entry.getKey());
                SerializationHelper.writeObject(dos, entry.getValue());
            }
        }
    }

    private Map readMap(DataInput in) throws IOException {
        int size = in.readInt();
        HashMap<Object, Object> props = new HashMap<Object, Object>(size);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                Object key = SerializationHelper.readObject(in);
                Object value = SerializationHelper.readObject(in);
                props.put(key, value);
            }
        }
        return props;
    }

    private void writeCollection(DataOutput dos, Collection result) throws IOException {
        int size = result != null ? result.size() : 0;
        dos.writeInt(size);
        if (size > 0) {
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                SerializationHelper.writeObject(dos, iter.next());
            }
        }
    }

    private Collection readCollection(DataInput in) throws IOException {
        int size = in.readInt();
        ArrayList<Object> coll = new ArrayList<Object>(size);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                Object value = SerializationHelper.readObject(in);
                coll.add(value);
            }
        }
        return coll;
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.script);
        out.writeUTF(this.engine);
        out.writeBoolean(this.targetAllMembers);
        out.writeInt(this.targets.size());
        for (Address target : this.targets) {
            target.writeData(out);
        }
        this.writeMap(out, this.bindings);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.script = in.readUTF();
        this.engine = in.readUTF();
        this.targetAllMembers = in.readBoolean();
        int size = in.readInt();
        this.targets = new HashSet<Address>(size);
        for (int i = 0; i < size; ++i) {
            Address target = new Address();
            target.readData(in);
            this.targets.add(target);
        }
        this.bindings = this.readMap(in);
    }
}

