/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.AssemblerHelp;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.assembler.exceptions.AmbiguousSpecificTypeException;
import com.hp.hpl.jena.assembler.exceptions.AssemblerException;
import com.hp.hpl.jena.assembler.exceptions.NoImplementationException;
import com.hp.hpl.jena.assembler.exceptions.NoSpecificTypeException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AssemblerGroup
extends AssemblerBase
implements Assembler {
    public abstract AssemblerGroup implementWith(Resource var1, Assembler var2);

    public abstract Assembler assemblerFor(Resource var1);

    public Model openModel(Resource resource) {
        return (Model)this.open(resource);
    }

    public static AssemblerGroup create() {
        return new ExpandingAssemblerGroup();
    }

    public AssemblerGroup copy() {
        ExpandingAssemblerGroup result = (ExpandingAssemblerGroup)AssemblerGroup.create();
        result.internal.mappings.putAll(((ExpandingAssemblerGroup)this).internal.mappings);
        return result;
    }

    static class PlainAssemblerGroup
    extends AssemblerGroup {
        Map mappings = new HashMap();

        PlainAssemblerGroup() {
        }

        public Object open(Assembler a, Resource root2, Mode mode) {
            Set types = AssemblerHelp.findSpecificTypes(root2, JA.Object);
            if (types.size() == 0) {
                throw new NoSpecificTypeException(root2);
            }
            if (types.size() > 1) {
                throw new AmbiguousSpecificTypeException(root2, new ArrayList(types));
            }
            return this.openBySpecificType(a, root2, mode, (Resource)types.iterator().next());
        }

        private Object openBySpecificType(Assembler a, Resource root2, Mode mode, Resource type) {
            Assembler toUse = this.assemblerFor(type);
            Class<?> aClass = toUse == null ? null : toUse.getClass();
            Frame frame = new Frame(root2, type, aClass);
            try {
                if (toUse == null) {
                    throw new NoImplementationException(this, root2, type);
                }
                return toUse.open(a, root2, mode);
            }
            catch (AssemblerException e2) {
                throw e2.pushDoing(frame);
            }
            catch (Exception e3) {
                AssemblerException x = new AssemblerException(root2, "caught: " + e3.getMessage(), e3);
                throw x.pushDoing(frame);
            }
        }

        public AssemblerGroup implementWith(Resource type, Assembler a) {
            this.mappings.put(type, a);
            return this;
        }

        public Assembler assemblerFor(Resource type) {
            return (Assembler)this.mappings.get(type);
        }
    }

    public static class ExpandingAssemblerGroup
    extends AssemblerGroup {
        PlainAssemblerGroup internal = new PlainAssemblerGroup();
        Model implementTypes = ModelFactory.createDefaultModel();

        public Object open(Assembler a, Resource suppliedRoot, Mode mode) {
            ArrayList doing = new ArrayList();
            Resource root2 = AssemblerHelp.withFullModel(suppliedRoot);
            this.loadClasses(root2.getModel());
            root2.getModel().add(this.implementTypes);
            return this.internal.open(a, root2, mode);
        }

        public void loadClasses(Model model) {
            AssemblerHelp.loadArbitraryClasses(this, model);
            AssemblerHelp.loadAssemblerClasses(this, model);
        }

        public AssemblerGroup implementWith(Resource type, Assembler a) {
            this.implementTypes.add(type, RDFS.subClassOf, JA.Object);
            this.internal.implementWith(type, a);
            return this;
        }

        public Assembler assemblerFor(Resource type) {
            return this.internal.assemblerFor(type);
        }

        public Set implementsTypes() {
            return this.implementTypes.listStatements().mapWith(Statement.Util.getSubject).toSet();
        }
    }

    public static class Frame {
        public final Resource root;
        public final Resource type;
        public final Class assembler;

        public Frame(Resource root2, Resource type, Class assembler) {
            this.root = root2;
            this.type = type;
            this.assembler = assembler;
        }

        public boolean equals(Object other) {
            return other instanceof Frame && this.same((Frame)other);
        }

        protected boolean same(Frame other) {
            return ((Object)this.root).equals(other.root) && ((Object)this.type).equals(other.type) && this.assembler.equals(other.assembler);
        }

        public String toString() {
            return "root: " + this.root + " with type: " + this.type + " assembler class: " + this.assembler;
        }
    }
}

