/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.RuleSet;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import java.util.ArrayList;
import java.util.List;

public class RuleSetAssembler
extends AssemblerBase
implements Assembler {
    public Object open(Assembler a, Resource root2, Mode irrelevant) {
        this.checkType(root2, JA.RuleSet);
        return RuleSetAssembler.createRuleSet(a, root2);
    }

    public static RuleSet createRuleSet(Assembler a, Resource root2) {
        return RuleSet.create(RuleSetAssembler.addRules(new ArrayList(), a, root2));
    }

    public static List addRules(List result, Assembler a, Resource root2) {
        RuleSetAssembler.addLiteralRules(root2, result);
        RuleSetAssembler.addIndirectRules(a, root2, result);
        RuleSetAssembler.addExternalRules(root2, result);
        return result;
    }

    private static void addIndirectRules(Assembler a, Resource root2, List result) {
        StmtIterator it = root2.listProperties(JA.rules);
        while (it.hasNext()) {
            Resource r = RuleSetAssembler.getResource(it.nextStatement());
            result.addAll(((RuleSet)a.open(r)).getRules());
        }
    }

    private static void addExternalRules(Resource root2, List result) {
        StmtIterator it = root2.listProperties(JA.rulesFrom);
        while (it.hasNext()) {
            Resource s = RuleSetAssembler.getResource(it.nextStatement());
            result.addAll(Rule.rulesFromURL(s.getURI()));
        }
    }

    private static void addLiteralRules(Resource root2, List result) {
        StmtIterator it = root2.listProperties(JA.rule);
        while (it.hasNext()) {
            String s = RuleSetAssembler.getString(it.nextStatement());
            result.addAll(Rule.parseRules(s));
        }
    }
}

