/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeCache;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import junit.framework.TestSuite;

public class TestNodeCache
extends GraphTestBase {
    protected static String[] someURIs = TestNodeCache.inventURIs();

    public TestNodeCache(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestNodeCache.class);
    }

    public static void main(String[] ignoredArguments) {
        String alphabet = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String[] strings = new String[32000];
        for (int i = 0; i < alphabet.length(); ++i) {
            for (int j = 0; j < alphabet.length(); ++j) {
                int hash;
                String s = "" + alphabet.charAt(i) + alphabet.charAt(j);
                if (i == 10 && j == 10) {
                    System.err.println(s);
                }
                if (strings[hash = s.hashCode()] == null) {
                    strings[hash] = s;
                    continue;
                }
                System.out.println(">> " + strings[hash] + " and " + s + " both hash to " + hash);
            }
        }
    }

    public void testClashettes() {
        TestNodeCache.assertEquals((int)"eg:aa".hashCode(), (int)"eg:bB".hashCode());
        TestNodeCache.assertEquals((int)"eg:ab".hashCode(), (int)"eg:bC".hashCode());
        TestNodeCache.assertEquals((int)"eg:ac".hashCode(), (int)"eg:bD".hashCode());
        TestNodeCache.assertEquals((int)"eg:Yv".hashCode(), (int)"eg:ZW".hashCode());
        TestNodeCache.assertEquals((int)"eg:Yx".hashCode(), (int)"eg:ZY".hashCode());
    }

    protected static String[] inventURIs() {
        String[] a = new String[]{"a", "mig", "spoo-", "gilbert", "124c41+"};
        String[] b = new String[]{"b", "class", "procedure", "spindizzy", "rake"};
        String[] c = new String[]{"c", "bucket", "42", "+1", "#mark"};
        int here = 0;
        String[] result = new String[a.length * b.length * c.length];
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < b.length; ++j) {
                for (int k = 0; k < c.length; ++k) {
                    result[here++] = "eg:" + a[i] + b[j] + c[k];
                }
            }
        }
        return result;
    }

    public void testNewCacheEmpty() {
        NodeCache c = new NodeCache();
        for (int i = 0; i < someURIs.length; ++i) {
            TestNodeCache.assertEquals(null, (Object)c.get(someURIs[i]));
        }
    }

    public void testNewCacheUpdates() {
        NodeCache c = new NodeCache();
        for (int i = 0; i < someURIs.length; ++i) {
            Node it = Node.createURI(someURIs[i]);
            c.put(someURIs[i], it);
            TestNodeCache.assertEquals((Object)it, (Object)c.get(someURIs[i]));
        }
    }

    public void testClashing() {
        String A = "eg:aa";
        String B = "eg:bB";
        TestNodeCache.assertEquals((int)A.hashCode(), (int)B.hashCode());
        NodeCache c = new NodeCache();
        c.put(A, Node.createURI(A));
        TestNodeCache.assertEquals(null, (Object)c.get(B));
        c.put(B, Node.createURI(B));
        TestNodeCache.assertEquals((Object)Node.createURI(B), (Object)c.get(B));
    }
}

