/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import junit.framework.TestSuite;

public class TestListSubjectsEtc
extends ModelTestBase {
    public TestListSubjectsEtc(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestListSubjectsEtc.class);
    }

    public void testListSubjectsNoRemove() {
        Model m = TestListSubjectsEtc.modelWithStatements("a P b; b Q c; c R a");
        ResIterator it = m.listSubjects();
        it.next();
        try {
            it.remove();
            TestListSubjectsEtc.fail((String)"listSubjects should not support .remove()");
        }
        catch (UnsupportedOperationException e2) {
            TestListSubjectsEtc.pass();
        }
    }

    public void testListObjectsNoRemove() {
        Model m = TestListSubjectsEtc.modelWithStatements("a P b; b Q c; c R a");
        NodeIterator it = m.listObjects();
        it.next();
        try {
            it.remove();
            TestListSubjectsEtc.fail((String)"listObjects should not support .remove()");
        }
        catch (UnsupportedOperationException e2) {
            TestListSubjectsEtc.pass();
        }
    }

    public void testListSubjectsWorksAfterRemoveProperties() {
        Model m = TestListSubjectsEtc.modelWithStatements("p1 before terminal; p2 before terminal");
        m.createResource("eh:/p1").removeProperties();
        TestListSubjectsEtc.assertIsoModels(TestListSubjectsEtc.modelWithStatements("p2 before terminal"), m);
        TestListSubjectsEtc.assertEquals((Object)TestListSubjectsEtc.resourceSet("p2"), (Object)m.listSubjects().toSet());
    }

    public void testListSubjectsWorksAfterRemovePropertiesWIthLots() {
        Model m = TestListSubjectsEtc.modelWithStatements("p2 before terminal");
        for (int i = 0; i < 100; ++i) {
            TestListSubjectsEtc.modelAdd(m, "p1 hasValue " + i);
        }
        m.createResource("eh:/p1").removeProperties();
        TestListSubjectsEtc.assertIsoModels(TestListSubjectsEtc.modelWithStatements("p2 before terminal"), m);
        TestListSubjectsEtc.assertEquals((Object)TestListSubjectsEtc.resourceSet("p2"), (Object)m.listSubjects().toSet());
    }
}

