/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.reasoner.dig.DIGConnectionPool;
import com.hp.hpl.jena.reasoner.dig.DIGErrorResponseException;
import com.hp.hpl.jena.reasoner.dig.DIGInconsistentKBException;
import com.hp.hpl.jena.reasoner.dig.DIGProfile;
import com.hp.hpl.jena.reasoner.dig.DIGReasonerException;
import com.hp.hpl.jena.reasoner.dig.DIGWrappedException;
import com.hp.hpl.jena.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DIGConnection {
    public static final String DEFAULT_REASONER_URL = "http://localhost:8081";
    public static final String XSI = "http://www.w3.org/2001/XMLSchema-instance";
    private static Log log = LogFactory.getLog(DIGConnection.class);
    protected String m_extReasonerURL = "http://localhost:8081";
    private String m_kbURI;
    protected DocumentBuilderFactory m_factory = DocumentBuilderFactory.newInstance();
    private List m_warnings = new ArrayList();
    protected boolean m_logCommunications = true;

    public Document sendDigVerb(Document digVerb, DIGProfile profile) {
        try {
            Element verb = digVerb.getDocumentElement();
            if (!verb.hasAttribute("uri")) {
                verb.setAttribute("uri", this.m_kbURI);
            }
            URL url = new URL(this.m_extReasonerURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            StringWriter out = new StringWriter();
            this.serialiseDocument(digVerb, out);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Length", Integer.toString(out.getBuffer().length()));
            conn.setRequestProperty("Content-Type", profile.getContentType());
            this.logMessage(true, digVerb);
            conn.connect();
            PrintWriter pw = FileUtils.asPrintWriterUTF8(conn.getOutputStream());
            pw.print(out.getBuffer());
            pw.flush();
            pw.close();
            Document response = this.getDigResponse(conn);
            this.logMessage(false, response);
            this.errorCheck(response, profile);
            return response;
        }
        catch (IOException e2) {
            throw new DIGWrappedException(e2);
        }
    }

    public void serialiseDocument(Document doc, Writer out) {
        try {
            XMLSerializer serializer = new XMLSerializer(out, this.createXMLFormatter(doc));
            serializer.asDOMSerializer();
            serializer.serialize(doc);
        }
        catch (IOException e2) {
            throw new DIGWrappedException(e2);
        }
    }

    public void bindKB(boolean rebind, DIGProfile profile) {
        if (rebind && this.m_kbURI != null) {
            Document release = this.createDigVerb("releaseKB", profile);
            Document response = this.sendDigVerb(release, profile);
            this.errorCheck(response, profile);
            if (this.warningCheck(response)) {
                log.warn("DIG reasoner warning: " + this.getWarnings().next());
            }
            this.m_kbURI = null;
        }
        if (this.m_kbURI == null) {
            Document response = this.sendDigVerb(this.createDigVerb("newKB", profile), profile);
            this.errorCheck(response, profile);
            Element kb = (Element)response.getDocumentElement().getElementsByTagName("kb").item(0);
            if (kb == null) {
                throw new DIGReasonerException("Could not locate DIG KB identifier in return value from newKB");
            }
            this.m_kbURI = kb.getAttribute("uri");
        }
    }

    public void errorCheck(Document response, DIGProfile profile) {
        Element root2 = response.getDocumentElement();
        NodeList errs = root2.getElementsByTagName("error");
        if (errs != null && errs.getLength() > 0) {
            String message;
            Element error = (Element)errs.item(0);
            String errCode = error.getAttribute("code");
            int code = errCode == null || errCode.length() == 0 ? 0 : Integer.parseInt(errCode);
            String msgAttr = error.getAttribute("message");
            NodeList messages = error.getChildNodes();
            String string = message = messages.getLength() > 0 ? ((Text)messages.item(0)).getNodeValue().trim() : "(no message)";
            if (message.equals(profile.getInconsistentKBMessage())) {
                throw new DIGInconsistentKBException(message, msgAttr, code);
            }
            throw new DIGErrorResponseException(message, msgAttr, code);
        }
    }

    public boolean warningCheck(Document response) {
        Element e2;
        NodeList warnings;
        Element root2 = response.getDocumentElement();
        NodeList ok = root2.getElementsByTagName("ok");
        this.m_warnings.clear();
        if (ok != null && ok.getLength() > 0 && (warnings = (e2 = (Element)ok.item(0)).getElementsByTagName("warning")) != null && warnings.getLength() > 0) {
            for (int i = 0; i < warnings.getLength(); ++i) {
                Element warn = (Element)warnings.item(i);
                this.m_warnings.add(warn.getAttribute("message"));
            }
            return true;
        }
        return false;
    }

    public Iterator getWarnings() {
        return this.m_warnings.iterator();
    }

    public void release() {
        DIGConnectionPool.getInstance().release(this);
    }

    public String getReasonerURL() {
        return this.m_extReasonerURL;
    }

    public void setReasonerURL(String url) {
        this.m_extReasonerURL = url;
        this.m_kbURI = null;
    }

    protected Document getDigResponse(HttpURLConnection conn) {
        try {
            if (conn.getResponseCode() != 200) {
                throw new DIGReasonerException("DIG reasoner returned failure code " + conn.getResponseCode() + ": " + conn.getResponseMessage());
            }
            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
            StringBuffer buf = new StringBuffer();
            int ch = in.read();
            while (ch > 0) {
                buf.append((char)ch);
                ch = in.read();
            }
            DocumentBuilder builder = this.m_factory.newDocumentBuilder();
            return builder.parse(new ByteArrayInputStream(buf.toString().getBytes()));
        }
        catch (Exception e2) {
            e2.printStackTrace(System.err);
            throw new DIGWrappedException(e2);
        }
    }

    protected OutputFormat createXMLFormatter(Document doc) {
        OutputFormat format = new OutputFormat(doc);
        format.setIndenting(true);
        format.setLineWidth(0);
        format.setPreserveSpace(false);
        return format;
    }

    protected Document createDigVerb(String verbName, DIGProfile profile) {
        try {
            DocumentBuilder builder = this.m_factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root2 = doc.createElementNS(profile.getDIGNamespace(), verbName);
            doc.appendChild(root2);
            root2.setAttribute("xmlns", profile.getDIGNamespace());
            root2.setAttribute("xmlns:xsi", XSI);
            root2.setAttributeNS(XSI, "xsi:schemaLocation", profile.getDIGNamespace() + " " + profile.getSchemaLocation());
            if (this.m_kbURI != null) {
                root2.setAttribute("uri", this.m_kbURI);
            }
            return doc;
        }
        catch (FactoryConfigurationError e2) {
            throw new DIGWrappedException(e2);
        }
        catch (ParserConfigurationException e3) {
            throw new DIGWrappedException(e3);
        }
    }

    protected void logMessage(boolean outgoing, Document msg) {
        if (this.m_logCommunications) {
            StringWriter out = new StringWriter();
            this.serialiseDocument(msg, out);
            if (log.isDebugEnabled()) {
                log.debug(outgoing ? "Sending to DIG reasoner ..." : "Received from DIG reasoner ...");
                log.debug(out);
            }
        }
    }
}

