/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.ProfileRegistry;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.IllegalParameterException;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.dig.DIGInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.LogFactory;

public class DIGReasoner
implements Reasoner {
    protected Capabilities capabilities;
    protected Graph m_tbox;
    protected ReasonerFactory m_factory;
    protected Resource m_configuration;
    protected String m_extReasonerURL = "http://localhost:8081";
    protected OntModelSpec m_ontLang = this.getModelSpec(ProfileRegistry.OWL_LANG);
    protected Model m_axioms = null;

    public DIGReasoner(Graph tbox, ReasonerFactory factory, Resource configuration) {
        this.m_tbox = tbox;
        this.m_factory = factory;
        this.m_configuration = configuration;
        this.configure(configuration);
    }

    public Reasoner bindSchema(Graph tbox) {
        return new DIGReasoner(tbox, this.m_factory, this.m_configuration);
    }

    public Reasoner bindSchema(Model tbox) {
        return this.bindSchema(tbox.getGraph());
    }

    public InfGraph bind(Graph data) {
        return new DIGInfGraph(data, this);
    }

    public void setDerivationLogging(boolean logOn) {
        throw new UnsupportedOperationException("DIG reasoner does not support derivation logging");
    }

    public Model getReasonerCapabilities() {
        return this.m_factory == null ? null : this.m_factory.getCapabilities();
    }

    public void addDescription(Model configSpec, Resource base) {
        if (this.m_configuration != null) {
            StmtIterator i = this.m_configuration.listProperties();
            while (i.hasNext()) {
                Statement st = i.nextStatement();
                configSpec.add(base, st.getPredicate(), st.getObject());
            }
        }
    }

    public boolean supportsProperty(Property property) {
        if (this.m_factory == null) {
            return false;
        }
        Model caps = this.m_factory.getCapabilities();
        Resource root2 = caps.getResource(this.m_factory.getURI());
        return caps.contains(root2, ReasonerVocabulary.supportsP, property);
    }

    public void setParameter(Property parameter, Object value) {
        if (!this.doSetParameter(parameter, value)) {
            throw new IllegalParameterException("DIGReasoner does not recognize configuration parameter " + parameter);
        }
        if (this.m_configuration == null) {
            Model configModel = ModelFactory.createDefaultModel();
            this.m_configuration = configModel.createResource();
        }
        Util.updateParameter(this.m_configuration, parameter, value);
    }

    public void configure(Resource configuration) {
        if (configuration != null) {
            StmtIterator i = configuration.listProperties();
            while (i.hasNext()) {
                Statement s = i.nextStatement();
                if (this.doSetParameter(s.getPredicate(), s.getObject())) continue;
            }
        }
    }

    public String getReasonerURL() {
        return this.m_extReasonerURL;
    }

    public OntModelSpec getOntLangModelSpec() {
        return this.m_ontLang;
    }

    public Graph getSchema() {
        return this.m_tbox;
    }

    public Model getAxioms() {
        return this.m_axioms;
    }

    public Capabilities getGraphCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new BaseInfGraph.InfCapabilities();
        }
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doSetParameter(Property parameter, Object value) {
        if (parameter.equals(ReasonerVocabulary.EXT_REASONER_URL)) {
            this.m_extReasonerURL = value instanceof Resource ? ((Resource)value).getURI() : value.toString();
            return true;
        }
        if (parameter.equals(ReasonerVocabulary.EXT_REASONER_ONT_LANG)) {
            String lang = value instanceof Resource ? ((Resource)value).getURI() : value.toString();
            this.m_ontLang = this.getModelSpec(lang);
            return true;
        }
        if (parameter.equals(ReasonerVocabulary.EXT_REASONER_AXIOMS)) {
            String axURL = value instanceof Resource ? ((Resource)value).getURI() : value.toString();
            this.m_axioms = ModelFactory.createDefaultModel();
            if (axURL.startsWith("file:")) {
                String fileName = axURL.substring(5);
                InputStream in = null;
                try {
                    in = FileUtils.openResourceFileAsStream(fileName);
                    this.m_axioms.read(in, axURL);
                }
                catch (FileNotFoundException e2) {
                    LogFactory.getLog(this.getClass()).error("Could not open DIG axioms " + axURL);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            } else {
                this.m_axioms.read(axURL);
            }
            return true;
        }
        return false;
    }

    protected OntModelSpec getModelSpec(String lang) {
        if (lang.equals(ProfileRegistry.OWL_LANG) || lang.equals(ProfileRegistry.OWL_DL_LANG) || lang.equals(ProfileRegistry.OWL_LITE_LANG)) {
            return OntModelSpec.OWL_MEM;
        }
        if (lang.equals("http://www.daml.org/2001/03/daml+oil#")) {
            return OntModelSpec.DAML_MEM;
        }
        if (lang.equals(ProfileRegistry.RDFS_LANG)) {
            return OntModelSpec.RDFS_MEM;
        }
        throw new IllegalParameterException("DIG reasoner did not recognise ontology language " + lang);
    }
}

