/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.probability.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityBase;
import com.hp.hpl.jena.sparql.engine.optimizer.util.Config;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProbabilityDataModel
extends ProbabilityBase {
    private static Log log = LogFactory.getLog(ProbabilityDataModel.class);

    public void create(Model dataModel, Config config) {
        super.create(dataModel);
        this.init(config);
    }

    public void load(Model dataModel, Model indexModel, Config config) {
        super.load(dataModel);
        this.init(config);
    }

    public double getProbability(Triple triple) {
        Node subject = triple.getSubject();
        Node predicate = triple.getPredicate();
        Node object = triple.getObject();
        double sp = this.getProbability(subject, new Triple(subject, Node.ANY, Node.ANY));
        double pp = this.getProbability(predicate, new Triple(Node.ANY, predicate, Node.ANY));
        double op = this.getProbability(object, new Triple(Node.ANY, Node.ANY, object));
        double p = -1.0;
        p = sp == 0.0 || pp == 0.0 || op == 0.0 ? 0.0 : this.check(this.getProbability(sp, pp, op));
        log.debug("Probability: " + sp + " [" + subject + "]");
        log.debug("Probability: " + pp + " [" + predicate + "]");
        log.debug("Probability: " + op + " [" + object + "]");
        log.debug("Probability: " + p + " [" + triple + "]");
        return p;
    }

    public double getSelectivity(Triple triple) {
        double s = 1.0;
        if (this.dataGraphSize > 0L) {
            s = new Long(this.selectivity.calculate(triple)).doubleValue() / (double)this.dataGraphSize;
        }
        log.debug("Selectivity: " + s + " [" + triple + "]");
        return s;
    }

    public double getProbability(Triple triple1, Triple triple2) {
        if (triple2 == null) {
            return this.getProbability(triple1);
        }
        double p = 1.0;
        log.debug("This model does not estimate joined probabilities: " + p + " [" + triple1 + ", " + triple2 + "]");
        return p;
    }

    public double getSelectivity(Triple triple1, Triple triple2) {
        if (triple2 == null) {
            return this.getSelectivity(triple1);
        }
        double s = 1.0;
        if (this.squaredDataGraphSize > 0L) {
            s = new Long(this.selectivity.calculate(triple1, triple2)).doubleValue() / (double)this.squaredDataGraphSize;
        }
        log.debug("Selectivity: " + s + " [" + triple1 + ", " + triple2 + "]");
        return s;
    }

    private double getProbability(Node node, Triple triple) {
        double s = 1.0;
        if (node.isVariable()) {
            return s;
        }
        if (this.graphStatisticsHandler == null) {
            log.debug("GraphStatisticsHandler required!");
            return s;
        }
        long size = this.graphStatisticsHandler.getStatistic(triple.getSubject(), triple.getPredicate(), triple.getObject());
        if (this.dataGraphSize > 0L) {
            s = new Long(size).doubleValue() / (double)this.dataGraphSize;
        }
        return s;
    }

    private void init(Config config) {
        this.minProbability = this.dataGraphSize > 0L ? 1.0 / (double)this.dataGraphSize : 0.0;
        if (config != null && !config.limitMinProbability()) {
            this.minProbability = Double.MIN_VALUE;
        }
        if (this.dataModel != null) {
            this.isLoaded = true;
        } else {
            log.debug("The probabilistic data model requires the model of the ontology");
        }
    }
}

