/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.iterator.test;

import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.FilterDropIterator;
import com.hp.hpl.jena.util.iterator.FilterKeepIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import junit.framework.TestSuite;

public class TestFilters
extends ModelTestBase {
    protected Filter containsA = new Filter(){

        public boolean accept(Object o) {
            return TestFilters.this.contains(o, 'a');
        }
    };

    public TestFilters(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestFilters.class);
    }

    public void testFilterAnyExists() {
        TestFilters.assertInstanceOf(Filter.class, Filter.any);
    }

    public void testFilterAnyAcceptsThings() {
        TestFilters.assertTrue((boolean)Filter.any.accept("hello"));
        TestFilters.assertTrue((boolean)Filter.any.accept(new Integer(17)));
        TestFilters.assertTrue((boolean)Filter.any.accept(TestFilters.node("frodo")));
        TestFilters.assertTrue((boolean)Filter.any.accept(TestFilters.node("_cheshire")));
        TestFilters.assertTrue((boolean)Filter.any.accept(TestFilters.node("17")));
        TestFilters.assertTrue((boolean)Filter.any.accept(TestFilters.triple("s p o")));
        TestFilters.assertTrue((boolean)Filter.any.accept(Filter.any));
        TestFilters.assertTrue((boolean)Filter.any.accept((Object)this));
    }

    public void testFilterFilterMethod() {
        ExtendedIterator it = Filter.any.filterKeep(NullIterator.instance);
        TestFilters.assertFalse((boolean)it.hasNext());
    }

    public void testFilteringThings() {
        ExtendedIterator it = TestFilters.iteratorOfStrings("gab geb bag big lava hall end");
        Filter f = new Filter(){

            public boolean accept(Object o) {
                return ((String)o).charAt(1) == 'a';
            }
        };
        TestFilters.assertEquals((Object)TestFilters.listOfStrings("gab bag lava hall"), (Object)TestFilters.iteratorToList(f.filterKeep(it)));
    }

    public void testAnyFilterSimple() {
        ExtendedIterator it = TestFilters.iteratorOfStrings("");
        TestFilters.assertSame((Object)it, (Object)Filter.any.filterKeep(it));
    }

    public void testFilterAnd() {
        Filter containsB = new Filter(){

            public boolean accept(Object o) {
                return TestFilters.this.contains(o, 'b');
            }
        };
        Filter f12 = this.containsA.and(containsB);
        TestFilters.assertFalse((boolean)f12.accept("a"));
        TestFilters.assertFalse((boolean)f12.accept("b"));
        TestFilters.assertTrue((boolean)f12.accept("ab"));
        TestFilters.assertTrue((boolean)f12.accept("xyzapqrbijk"));
        TestFilters.assertTrue((boolean)f12.accept("ba"));
    }

    public void testFilterShortcircuit() {
        Filter oops = new Filter(){

            public boolean accept(Object o) {
                throw new JenaException("oops");
            }
        };
        Filter f12 = this.containsA.and(oops);
        TestFilters.assertFalse((boolean)f12.accept("z"));
        try {
            f12.accept("a");
            TestFilters.fail((String)"oops");
        }
        catch (JenaException e2) {
            TestFilters.assertEquals((String)"oops", (String)e2.getMessage());
        }
    }

    public void testAnyAndTrivial() {
        TestFilters.assertSame((Object)this.containsA, (Object)Filter.any.and(this.containsA));
    }

    public void testSomethingAndAny() {
        TestFilters.assertSame((Object)this.containsA, (Object)this.containsA.and(Filter.any));
    }

    public void testFilterDropIterator() {
        ExtendedIterator i = TestFilters.iteratorOfStrings("there's an a in some animals");
        FilterDropIterator it = new FilterDropIterator(this.containsA, i);
        TestFilters.assertEquals((Object)TestFilters.listOfStrings("there's in some"), (Object)TestFilters.iteratorToList(it));
    }

    public void testFilterKeepIterator() {
        ExtendedIterator i = TestFilters.iteratorOfStrings("there's an a in some animals");
        FilterKeepIterator it = new FilterKeepIterator(this.containsA, i);
        TestFilters.assertEquals((Object)TestFilters.listOfStrings("an a animals"), (Object)TestFilters.iteratorToList(it));
    }

    protected boolean contains(Object o, char ch) {
        return o.toString().indexOf(ch) > -1;
    }
}

