/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.util.FileUtils;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestFileUtils
extends TestCase {
    public TestFileUtils(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestFileUtils.class);
    }

    public void testLangXML() {
        TestFileUtils.assertEquals((String)"RDF/XML", (String)"RDF/XML");
    }

    public void testLangXMLAbbrev() {
        TestFileUtils.assertEquals((String)"RDF/XML-ABBREV", (String)"RDF/XML-ABBREV");
    }

    public void testLangNTriple() {
        TestFileUtils.assertEquals((String)"N-TRIPLE", (String)"N-TRIPLE");
    }

    public void testLangN3() {
        TestFileUtils.assertEquals((String)"N3", (String)"N3");
    }

    public void testLangTurtle() {
        TestFileUtils.assertEquals((String)"TURTLE", (String)"TURTLE");
    }

    public void testGuessLangLowerCase() {
        TestFileUtils.assertEquals((String)"N3", (String)FileUtils.guessLang("simple.n3"));
        TestFileUtils.assertEquals((String)"N3", (String)FileUtils.guessLang("hello.there.n3"));
        TestFileUtils.assertEquals((String)"TURTLE", (String)FileUtils.guessLang("simple.ttl"));
        TestFileUtils.assertEquals((String)"TURTLE", (String)FileUtils.guessLang("hello.there.ttl"));
        TestFileUtils.assertEquals((String)"N-TRIPLE", (String)FileUtils.guessLang("simple.nt"));
        TestFileUtils.assertEquals((String)"N-TRIPLE", (String)FileUtils.guessLang("whats.up.nt"));
        TestFileUtils.assertEquals((String)"RDF/XML", (String)FileUtils.guessLang("poggle.rdf"));
        TestFileUtils.assertEquals((String)"RDF/XML", (String)FileUtils.guessLang("wise.owl"));
        TestFileUtils.assertEquals((String)"RDF/XML", (String)FileUtils.guessLang("dotless"));
    }

    public void testGuessLangMixedCase() {
        TestFileUtils.assertEquals((String)"N3", (String)FileUtils.guessLang("simple.N3"));
        TestFileUtils.assertEquals((String)"N3", (String)FileUtils.guessLang("hello.there.N3"));
        TestFileUtils.assertEquals((String)"TURTLE", (String)FileUtils.guessLang("simple.TTL"));
        TestFileUtils.assertEquals((String)"TURTLE", (String)FileUtils.guessLang("hello.there.TTL"));
        TestFileUtils.assertEquals((String)"N-TRIPLE", (String)FileUtils.guessLang("simple.NT"));
        TestFileUtils.assertEquals((String)"N-TRIPLE", (String)FileUtils.guessLang("whats.up.Nt"));
        TestFileUtils.assertEquals((String)"RDF/XML", (String)FileUtils.guessLang("poggle.rDf"));
        TestFileUtils.assertEquals((String)"RDF/XML", (String)FileUtils.guessLang("wise.OwL"));
        TestFileUtils.assertEquals((String)"RDF/XML", (String)FileUtils.guessLang("dotless"));
    }

    public void testGuessLangFallback() {
        TestFileUtils.assertEquals((String)"spoo", (String)FileUtils.guessLang("noSuffix", "spoo"));
        TestFileUtils.assertEquals((String)"pots", (String)FileUtils.guessLang("suffix.unknown", "pots"));
        TestFileUtils.assertEquals((String)"RDF/XML", (String)FileUtils.guessLang("rdf.rdf", "spoo"));
        TestFileUtils.assertEquals((String)"RDF/XML", (String)FileUtils.guessLang("rdf.owl", "spoo"));
    }

    public void testMisplacedDots() {
        TestFileUtils.assertEquals((String)"spoo", (String)FileUtils.guessLang("stuff.left/right", "spoo"));
        TestFileUtils.assertEquals((String)"spoo", (String)FileUtils.guessLang("stuff.left\\right", "spoo"));
    }

    public void testFilename1() {
        this.isFilename("foo");
    }

    public void testFilename2() {
        this.isFilename("foo/bar");
    }

    public void testFilename3() {
        this.isFilename("foo\\bar");
    }

    public void testFilename4() {
        this.isFilename("\\bar");
    }

    public void testFilename5() {
        this.isFilename("foo/bar");
    }

    public void testFilename6() {
        this.isFilename("c:foo");
    }

    public void testFilename7() {
        this.isFilename("c:\\foo");
    }

    public void testFilename8() {
        this.isFilename("c:\\foo\\bar");
    }

    public void testFilename9() {
        this.isFilename("file::foo");
    }

    public void testFilename10() {
        this.isNotFilename("http://www.hp.com/");
    }

    public void testFilename11() {
        this.isNotFilename("urn:tag:stuff");
    }

    public void testTranslateFilename1() {
        this.checkToFilename("file:Dir/File", "Dir/File");
    }

    public void testTranslateFilename2() {
        this.checkToFilename("c:\\Dir\\File", "c:\\Dir\\File");
    }

    public void testTranslateFilename3() {
        this.checkToFilename("unknown:File", null);
    }

    public void testTranslateFilename4() {
        this.checkToFilename("file:Dir/File With Space", "Dir/File With Space");
    }

    public void testTranslateFilename5() {
        this.checkToFilename("file:Dir/File%20With Enc%21", "Dir/File With Enc!");
    }

    public void testTranslateFilename6() {
        this.checkToFilename("file:///dir/file", "/dir/file");
    }

    public void testTranslateFilename7() {
        this.checkToFilename("file:///c:/dir/file", "/c:/dir/file");
    }

    public void testTranslateFilename8() {
        this.checkToFilename("file:file", "file");
    }

    public void testTranslateFilename9() {
        this.checkToFilename("file://file", "//file");
    }

    public void testTranslateFilename10() {
        this.checkToFilename("Dir/File%20With Enc%21", "Dir/File%20With Enc%21");
    }

    public void testTranslateFilename11() {
        this.checkToFilename("Dir/File+With+Plus", "Dir/File+With+Plus");
    }

    public void testTranslateFilename12() {
        this.checkToFilename("file:Dir/File+With+Plus", "Dir/File+With+Plus");
    }

    void isFilename(String fn) {
        TestFileUtils.assertTrue((String)("Should be a file name : " + fn), (boolean)FileUtils.isFile(fn));
    }

    void isNotFilename(String fn) {
        TestFileUtils.assertFalse((String)("Shouldn't be a  file name: " + fn), (boolean)FileUtils.isFile(fn));
    }

    void checkToFilename(String url, String fn) {
        String t = FileUtils.toFilename(url);
        TestFileUtils.assertEquals((String)("Wrong: " + t + " != " + fn), (String)t, (String)fn);
    }

    public void testToURL1() {
        this.checkToURL("A%H", "%25");
    }

    public void testToURL2() {
        this.checkToURL("A#H", "%23");
    }

    public void testToURL3() {
        this.checkToURL("A?H", "%3F");
    }

    public void testToURL4() {
        this.checkToURL("A H", "%20");
    }

    public void testToURL5() {
        this.checkToURL("\u00c3\u00bc", "\u00c3\u00bc");
    }

    private void checkToURL(String fn, String match2) {
        String r = FileUtils.toURL(fn);
        if (!r.matches("^.*/[^/]*" + match2 + "[^/]*$")) {
            TestFileUtils.fail((String)("Converted \"" + fn + "\" to <" + r + "> which did not match /" + match2 + "/"));
        }
        if (!r.startsWith("file:///")) {
            TestFileUtils.fail((String)("Converted \"" + fn + "\" to <" + r + "> which does not start file:///"));
        }
        if (r.startsWith("file:////")) {
            TestFileUtils.fail((String)("Converted \"" + fn + "\" to <" + r + "> which has too many initial /"));
        }
    }
}

