/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.xmloutput.impl.BaseXMLWriter;
import com.hp.hpl.jena.xmloutput.impl.SimpleLogger;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.regex.Pattern;

public class XMLOutputTestBase
extends ModelTestBase {
    protected final String lang;
    static SimpleLogger realLogger;
    static boolean sawErrors;
    static SimpleLogger falseLogger;

    public XMLOutputTestBase(String name, String lang) {
        super(name);
        this.lang = lang;
    }

    static void blockLogger() {
        realLogger = BaseXMLWriter.setLogger(falseLogger);
        sawErrors = false;
    }

    static boolean unblockLogger() {
        BaseXMLWriter.setLogger(realLogger);
        return sawErrors;
    }

    protected void check(String filename, String regex, Change code) throws IOException {
        this.check(filename, regex, null, code);
    }

    protected void check(String filename, String regexPresent, String regexAbsent, Change code) throws IOException {
        this.check(filename, null, regexPresent, regexAbsent, false, code);
    }

    protected void check(String filename, String encoding, String regexPresent, String regexAbsent, Change code) throws IOException {
        this.check(filename, encoding, regexPresent, regexAbsent, false, code);
    }

    protected void check(String filename, String regexAbsent, Change code, String base) throws IOException {
        this.check(filename, null, regexAbsent, null, false, Change.none(), base);
        this.check(filename, null, null, regexAbsent, false, code, base);
    }

    protected void check(String filename, String encoding, String regexPresent, String regexAbsent, boolean errs, Change code) throws IOException {
        this.check(filename, encoding, regexPresent, regexAbsent, errs, code, "file:" + filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check(String filename, String encoding, String regexPresent, String regexAbsent, boolean errorExpected, Change code, String base) throws IOException {
        boolean errorsFound;
        Writer sw;
        XMLOutputTestBase.blockLogger();
        Model m = XMLOutputTestBase.createMemModel();
        FileInputStream in = new FileInputStream(filename);
        m.read(in, base);
        ((InputStream)in).close();
        ByteArrayOutputStream bos = null;
        if (encoding == null) {
            sw = new StringWriter();
        } else {
            bos = new ByteArrayOutputStream();
            sw = new OutputStreamWriter((OutputStream)bos, encoding);
        }
        Properties p = (Properties)System.getProperties().clone();
        RDFWriter writer = m.getWriter(this.lang);
        code.modify(m, writer);
        writer.write(m, sw, base);
        sw.close();
        String contents = encoding == null ? sw.toString() : bos.toString(encoding);
        try {
            Model m2 = XMLOutputTestBase.createMemModel();
            m2.read(new StringReader(contents), base);
            XMLOutputTestBase.assertTrue((String)"Data got changed.", (boolean)m.isIsomorphicWith(m2));
            if (regexPresent != null) {
                XMLOutputTestBase.assertTrue((String)("Should find /" + regexPresent + "/"), (boolean)Pattern.compile(regexPresent, 32).matcher(contents).find());
            }
            if (regexAbsent != null) {
                XMLOutputTestBase.assertTrue((String)("Should not find /" + regexAbsent + "/"), (!Pattern.compile(regexAbsent, 32).matcher(contents).find() ? (byte)1 : 0) != 0);
            }
            contents = null;
        }
        finally {
            errorsFound = XMLOutputTestBase.unblockLogger();
            System.setProperties(p);
            if (contents != null) {
                System.err.println("===================");
                System.err.println("Offending content - " + this.toString());
                System.err.println("===================");
                System.err.println(contents);
                System.err.println("===================");
            }
        }
        XMLOutputTestBase.assertEquals((String)"Errors (not) detected.", (boolean)errorExpected, (boolean)errorsFound);
    }

    static {
        falseLogger = new SimpleLogger(){

            public void warn(String s) {
                sawErrors = true;
            }

            public void warn(String s, Exception e2) {
                sawErrors = true;
            }
        };
    }

    protected static class Change {
        protected Change() {
        }

        public void modify(RDFWriter w) {
        }

        public void modify(Model m) {
        }

        public void modify(Model m, RDFWriter w) {
            this.modify(m);
            this.modify(w);
        }

        public static Change none() {
            return new Change();
        }

        public static Change setProperty(final String property, final String value) {
            return new Change(){

                public void modify(RDFWriter writer) {
                    writer.setProperty(property, value);
                }
            };
        }

        public static Change setProperty(final String property, final boolean value) {
            return new Change(){

                public void modify(RDFWriter writer) {
                    writer.setProperty(property, value);
                }
            };
        }

        public static Change setPrefix(final String prefix, final String URI2) {
            return new Change(){

                public void modify(Model m) {
                    m.setNsPrefix(prefix, URI2);
                }
            };
        }

        public static Change blockRules(String ruleName) {
            return Change.setProperty("blockrules", ruleName);
        }

        public Change andSetPrefix(String prefix, String URI2) {
            return this.and(Change.setPrefix(prefix, URI2));
        }

        private Change and(final Change change) {
            return new Change(){

                public void modify(Model m, RDFWriter w) {
                    Change.this.modify(m, w);
                    change.modify(m, w);
                }
            };
        }
    }
}

