/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.receivers.db.dialect;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.log4j.component.spi.ComponentBase;
import org.apache.log4j.receivers.db.dialect.HSQLDBDialect;
import org.apache.log4j.receivers.db.dialect.MsSQLDialect;
import org.apache.log4j.receivers.db.dialect.MySQLDialect;
import org.apache.log4j.receivers.db.dialect.OracleDialect;
import org.apache.log4j.receivers.db.dialect.PostgreSQLDialect;
import org.apache.log4j.receivers.db.dialect.SQLDialect;

public class Util
extends ComponentBase {
    private static final String POSTGRES_PART = "postgresql";
    private static final String MYSQL_PART = "mysql";
    private static final String ORACLE_PART = "oracle";
    private static final String MSSQL_PART = "microsoft";
    private static final String HSQL_PART = "hsql";

    public static int discoverSQLDialect(DatabaseMetaData meta) {
        int dialectCode = 0;
        try {
            String dbName = meta.getDatabaseProductName().toLowerCase();
            if (dbName.indexOf(POSTGRES_PART) != -1) {
                return 1;
            }
            if (dbName.indexOf(MYSQL_PART) != -1) {
                return 2;
            }
            if (dbName.indexOf(ORACLE_PART) != -1) {
                return 3;
            }
            if (dbName.indexOf(MSSQL_PART) != -1) {
                return 4;
            }
            if (dbName.indexOf(HSQL_PART) != -1) {
                return 5;
            }
            return 0;
        }
        catch (SQLException sQLException) {
            return dialectCode;
        }
    }

    public static SQLDialect getDialectFromCode(int dialectCode) {
        SQLDialect sqlDialect = null;
        switch (dialectCode) {
            case 1: {
                sqlDialect = new PostgreSQLDialect();
                break;
            }
            case 2: {
                sqlDialect = new MySQLDialect();
                break;
            }
            case 3: {
                sqlDialect = new OracleDialect();
                break;
            }
            case 4: {
                sqlDialect = new MsSQLDialect();
                break;
            }
            case 5: {
                sqlDialect = new HSQLDBDialect();
            }
        }
        return sqlDialect;
    }

    public boolean supportsGetGeneratedKeys(DatabaseMetaData meta) {
        try {
            return (Boolean)DatabaseMetaData.class.getMethod("supportsGetGeneratedKeys", null).invoke((Object)meta, null);
        }
        catch (Throwable e2) {
            this.getLogger().info("Could not call supportsGetGeneratedKeys method. This may be recoverable");
            return false;
        }
    }

    public boolean supportsBatchUpdates(DatabaseMetaData meta) {
        try {
            return meta.supportsBatchUpdates();
        }
        catch (Throwable e2) {
            this.getLogger().info("Missing DatabaseMetaData.supportsBatchUpdates method.");
            return false;
        }
    }
}

