/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMFile;

public class RAMOutputStream
extends IndexOutput {
    static final int BUFFER_SIZE = 1024;
    private RAMFile file;
    private byte[] currentBuffer;
    private int currentBufferIndex;
    private int bufferPosition;
    private long bufferStart;
    private int bufferLength;

    public RAMOutputStream() {
        this(new RAMFile());
    }

    RAMOutputStream(RAMFile f) {
        this.file = f;
        this.currentBufferIndex = -1;
        this.currentBuffer = null;
    }

    public void writeTo(IndexOutput out) throws IOException {
        this.flush();
        long end = this.file.length;
        long pos = 0L;
        int buffer = 0;
        while (pos < end) {
            int length = 1024;
            long nextPos = pos + (long)length;
            if (nextPos > end) {
                length = (int)(end - pos);
            }
            out.writeBytes((byte[])this.file.buffers.get(buffer++), length);
            pos = nextPos;
        }
    }

    public void reset() {
        try {
            this.seek(0L);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2.toString());
        }
        this.file.setLength(0L);
    }

    public void close() throws IOException {
        this.flush();
    }

    public void seek(long pos) throws IOException {
        this.setFileLength();
        if (pos < this.bufferStart || pos >= this.bufferStart + (long)this.bufferLength) {
            this.currentBufferIndex = (int)(pos / 1024L);
            this.switchCurrentBuffer();
        }
        this.bufferPosition = (int)(pos % 1024L);
    }

    public long length() {
        return this.file.length;
    }

    public void writeByte(byte b) throws IOException {
        if (this.bufferPosition == this.bufferLength) {
            ++this.currentBufferIndex;
            this.switchCurrentBuffer();
        }
        this.currentBuffer[this.bufferPosition++] = b;
    }

    public void writeBytes(byte[] b, int offset, int len) throws IOException {
        while (len > 0) {
            int remainInBuffer;
            if (this.bufferPosition == this.bufferLength) {
                ++this.currentBufferIndex;
                this.switchCurrentBuffer();
            }
            int bytesToCopy = len < (remainInBuffer = this.currentBuffer.length - this.bufferPosition) ? len : remainInBuffer;
            System.arraycopy(b, offset, this.currentBuffer, this.bufferPosition, bytesToCopy);
            offset += bytesToCopy;
            len -= bytesToCopy;
            this.bufferPosition += bytesToCopy;
        }
    }

    private final void switchCurrentBuffer() throws IOException {
        this.currentBuffer = this.currentBufferIndex == this.file.buffers.size() ? this.file.addBuffer(1024) : (byte[])this.file.buffers.get(this.currentBufferIndex);
        this.bufferPosition = 0;
        this.bufferStart = 1024 * this.currentBufferIndex;
        this.bufferLength = this.currentBuffer.length;
    }

    private void setFileLength() {
        long pointer = this.bufferStart + (long)this.bufferPosition;
        if (pointer > this.file.length) {
            this.file.setLength(pointer);
        }
    }

    public void flush() throws IOException {
        this.file.setLastModified(System.currentTimeMillis());
        this.setFileLength();
    }

    public long getFilePointer() {
        return this.currentBufferIndex < 0 ? 0L : this.bufferStart + (long)this.bufferPosition;
    }
}

