/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.CyclicDependencyException;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.resolver.ResolutionListenerForDepMgmt;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.ManagedVersionMap;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;

public class DefaultArtifactCollector
implements ArtifactCollector {
    public ArtifactResolutionResult collect(Set artifacts, Artifact originatingArtifact, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List listeners) throws ArtifactResolutionException {
        return this.collect(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, filter, listeners);
    }

    public ArtifactResolutionResult collect(Set artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List listeners) throws ArtifactResolutionException {
        HashMap resolvedArtifacts = new HashMap();
        ResolutionNode root2 = new ResolutionNode(originatingArtifact, remoteRepositories);
        root2.addDependencies(artifacts, remoteRepositories, filter);
        ManagedVersionMap versionMap = managedVersions != null && managedVersions instanceof ManagedVersionMap ? (ManagedVersionMap)managedVersions : new ManagedVersionMap(managedVersions);
        this.recurse(root2, resolvedArtifacts, versionMap, localRepository, remoteRepositories, source, filter, listeners);
        HashSet<ResolutionNode> set = new HashSet<ResolutionNode>();
        Iterator i = resolvedArtifacts.values().iterator();
        while (i.hasNext()) {
            List nodes = (List)i.next();
            Iterator j = nodes.iterator();
            while (j.hasNext()) {
                ResolutionNode node = (ResolutionNode)j.next();
                if (node.equals(root2) || !node.isActive()) continue;
                Artifact artifact = node.getArtifact();
                if (!node.filterTrail(filter) || !node.isChildOfRootNode() && artifact.isOptional()) continue;
                artifact.setDependencyTrail(node.getDependencyTrail());
                set.add(node);
            }
        }
        ArtifactResolutionResult result = new ArtifactResolutionResult();
        result.setArtifactResolutionNodes(set);
        return result;
    }

    private void recurse(ResolutionNode node, Map resolvedArtifacts, ManagedVersionMap managedVersions, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List listeners) throws CyclicDependencyException, ArtifactResolutionException, OverConstrainedVersionException {
        Iterator i;
        ArrayList<ResolutionNode> previousNodes;
        this.fireEvent(1, listeners, node);
        Object key = node.getKey();
        if (managedVersions.containsKey(key)) {
            this.manageArtifact(node, managedVersions, listeners);
        }
        if ((previousNodes = (ArrayList<ResolutionNode>)resolvedArtifacts.get(key)) != null) {
            i = previousNodes.iterator();
            while (i.hasNext()) {
                ResolutionNode farthest;
                ResolutionNode nearest;
                ResolutionNode previous = (ResolutionNode)i.next();
                if (!previous.isActive()) continue;
                VersionRange previousRange = previous.getArtifact().getVersionRange();
                VersionRange currentRange = node.getArtifact().getVersionRange();
                if (previousRange != null && currentRange != null) {
                    VersionRange newRange = previousRange.restrict(currentRange);
                    if (newRange.isSelectedVersionKnown(previous.getArtifact())) {
                        this.fireEvent(11, listeners, node, previous.getArtifact(), newRange);
                    }
                    previous.getArtifact().setVersionRange(newRange);
                    node.getArtifact().setVersionRange(currentRange.restrict(previousRange));
                    ResolutionNode[] resetNodes = new ResolutionNode[]{previous, node};
                    for (int j = 0; j < 2; ++j) {
                        Artifact resetArtifact = resetNodes[j].getArtifact();
                        if (resetArtifact.getVersion() != null || resetArtifact.getVersionRange() == null || resetArtifact.getAvailableVersions() == null) continue;
                        resetArtifact.selectVersion(resetArtifact.getVersionRange().matchVersion(resetArtifact.getAvailableVersions()).toString());
                        this.fireEvent(10, listeners, resetNodes[j]);
                    }
                }
                if (previous.getDepth() <= node.getDepth()) {
                    nearest = previous;
                    farthest = node;
                } else {
                    nearest = node;
                    farthest = previous;
                }
                if (this.checkScopeUpdate(farthest, nearest, listeners)) {
                    nearest.disable();
                    farthest.getArtifact().setVersion(nearest.getArtifact().getVersion());
                } else {
                    farthest.disable();
                }
                this.fireEvent(5, listeners, farthest, nearest.getArtifact());
            }
        } else {
            previousNodes = new ArrayList<ResolutionNode>();
            resolvedArtifacts.put(key, previousNodes);
        }
        previousNodes.add(node);
        if (node.isActive()) {
            this.fireEvent(4, listeners, node);
        }
        if (node.isActive() && !"system".equals(node.getArtifact().getScope())) {
            this.fireEvent(2, listeners, node);
            i = node.getChildrenIterator();
            while (i.hasNext()) {
                ResolutionNode child = (ResolutionNode)i.next();
                if (child.isResolved() || child.getArtifact().isOptional() && !child.isChildOfRootNode()) continue;
                Artifact artifact = child.getArtifact();
                try {
                    Object childKey;
                    if (artifact.getVersion() == null) {
                        ArtifactVersion version2;
                        if (!artifact.isSelectedVersionKnown()) {
                            VersionRange versionRange;
                            List versions = artifact.getAvailableVersions();
                            if (versions == null) {
                                versions = source.retrieveAvailableVersions(artifact, localRepository, remoteRepositories);
                                artifact.setAvailableVersions(versions);
                            }
                            if ((version2 = (versionRange = artifact.getVersionRange()).matchVersion(versions)) == null) {
                                if (versions.isEmpty()) {
                                    throw new OverConstrainedVersionException("No versions are present in the repository for the artifact with a range " + versionRange, artifact, remoteRepositories);
                                }
                                throw new OverConstrainedVersionException("Couldn't find a version in " + versions + " to match range " + versionRange, artifact, remoteRepositories);
                            }
                        } else {
                            version2 = artifact.getSelectedVersion();
                        }
                        artifact.selectVersion(version2.toString());
                        this.fireEvent(10, listeners, child);
                    }
                    if (managedVersions.containsKey(childKey = child.getKey())) {
                        this.manageArtifact(child, managedVersions, listeners);
                        Artifact ma = (Artifact)managedVersions.get(childKey);
                        ArtifactFilter managedExclusionFilter = ma.getDependencyFilter();
                        if (null != managedExclusionFilter) {
                            if (null != artifact.getDependencyFilter()) {
                                AndArtifactFilter aaf = new AndArtifactFilter();
                                aaf.add(artifact.getDependencyFilter());
                                aaf.add(managedExclusionFilter);
                                artifact.setDependencyFilter(aaf);
                            } else {
                                artifact.setDependencyFilter(managedExclusionFilter);
                            }
                        }
                    }
                    artifact.setDependencyTrail(node.getDependencyTrail());
                    ResolutionGroup rGroup = source.retrieve(artifact, localRepository, remoteRepositories);
                    if (rGroup == null) continue;
                    child.addDependencies(rGroup.getArtifacts(), rGroup.getResolutionRepositories(), filter);
                }
                catch (CyclicDependencyException e2) {
                    this.fireEvent(8, listeners, new ResolutionNode(e2.getArtifact(), remoteRepositories, child));
                }
                catch (ArtifactMetadataRetrievalException e3) {
                    artifact.setDependencyTrail(node.getDependencyTrail());
                    throw new ArtifactResolutionException("Unable to get dependency information: " + e3.getMessage(), artifact, remoteRepositories, e3);
                }
                this.recurse(child, resolvedArtifacts, managedVersions, localRepository, remoteRepositories, source, filter, listeners);
            }
            this.fireEvent(3, listeners, node);
        }
    }

    private void manageArtifact(ResolutionNode node, ManagedVersionMap managedVersions, List listeners) {
        Artifact artifact = (Artifact)managedVersions.get(node.getKey());
        if (!(artifact.getVersion() == null || node.isChildOfRootNode() && node.getArtifact().getVersion() != null)) {
            this.fireEvent(12, listeners, node, artifact);
            node.getArtifact().setVersion(artifact.getVersion());
        }
        if (!(artifact.getScope() == null || node.isChildOfRootNode() && node.getArtifact().getScope() != null)) {
            this.fireEvent(13, listeners, node, artifact);
            node.getArtifact().setScope(artifact.getScope());
        }
    }

    boolean checkScopeUpdate(ResolutionNode farthest, ResolutionNode nearest, List listeners) {
        boolean updateScope = false;
        Artifact farthestArtifact = farthest.getArtifact();
        Artifact nearestArtifact = nearest.getArtifact();
        if ("runtime".equals(farthestArtifact.getScope()) && ("test".equals(nearestArtifact.getScope()) || "provided".equals(nearestArtifact.getScope()))) {
            updateScope = true;
        }
        if ("compile".equals(farthestArtifact.getScope()) && !"compile".equals(nearestArtifact.getScope())) {
            updateScope = true;
        }
        if (nearest.getDepth() < 2 && updateScope) {
            updateScope = false;
            this.fireEvent(9, listeners, nearest, farthestArtifact);
        }
        if (updateScope) {
            this.fireEvent(6, listeners, nearest, farthestArtifact);
            nearestArtifact.setScope(farthestArtifact.getScope());
        }
        return updateScope;
    }

    private void fireEvent(int event, List listeners, ResolutionNode node) {
        this.fireEvent(event, listeners, node, null);
    }

    private void fireEvent(int event, List listeners, ResolutionNode node, Artifact replacement) {
        this.fireEvent(event, listeners, node, replacement, null);
    }

    private void fireEvent(int event, List listeners, ResolutionNode node, Artifact replacement, VersionRange newRange) {
        Iterator i = listeners.iterator();
        block14: while (i.hasNext()) {
            ResolutionListener listener = (ResolutionListener)i.next();
            switch (event) {
                case 1: {
                    listener.testArtifact(node.getArtifact());
                    continue block14;
                }
                case 2: {
                    listener.startProcessChildren(node.getArtifact());
                    continue block14;
                }
                case 3: {
                    listener.endProcessChildren(node.getArtifact());
                    continue block14;
                }
                case 4: {
                    listener.includeArtifact(node.getArtifact());
                    continue block14;
                }
                case 5: {
                    String version2 = node.getArtifact().getVersion();
                    String replacementVersion = replacement.getVersion();
                    if (!(version2 != null ? !version2.equals(replacementVersion) : replacementVersion != null)) continue block14;
                    listener.omitForNearer(node.getArtifact(), replacement);
                    continue block14;
                }
                case 8: {
                    listener.omitForCycle(node.getArtifact());
                    continue block14;
                }
                case 6: {
                    listener.updateScope(node.getArtifact(), replacement.getScope());
                    continue block14;
                }
                case 9: {
                    listener.updateScopeCurrentPom(node.getArtifact(), replacement.getScope());
                    continue block14;
                }
                case 12: {
                    ResolutionListenerForDepMgmt asImpl;
                    if (listener instanceof ResolutionListenerForDepMgmt) {
                        asImpl = (ResolutionListenerForDepMgmt)((Object)listener);
                        asImpl.manageArtifactVersion(node.getArtifact(), replacement);
                        continue block14;
                    }
                    listener.manageArtifact(node.getArtifact(), replacement);
                    continue block14;
                }
                case 13: {
                    ResolutionListenerForDepMgmt asImpl;
                    if (listener instanceof ResolutionListenerForDepMgmt) {
                        asImpl = (ResolutionListenerForDepMgmt)((Object)listener);
                        asImpl.manageArtifactScope(node.getArtifact(), replacement);
                        continue block14;
                    }
                    listener.manageArtifact(node.getArtifact(), replacement);
                    continue block14;
                }
                case 10: {
                    listener.selectVersionFromRange(node.getArtifact());
                    continue block14;
                }
                case 11: {
                    if (!node.getArtifact().getVersionRange().hasRestrictions() && !replacement.getVersionRange().hasRestrictions()) continue block14;
                    listener.restrictRange(node.getArtifact(), replacement, newRange);
                    continue block14;
                }
            }
            throw new IllegalStateException("Unknown event: " + event);
        }
    }
}

