/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactStatus;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.ManagedVersionMap;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Repository;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.MavenProfilesBuilder;
import org.apache.maven.profiles.Profile;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.ProfilesConversionUtils;
import org.apache.maven.profiles.ProfilesRoot;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ModelUtils;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectUtils;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.inheritance.ModelInheritanceAssembler;
import org.apache.maven.project.injection.ModelDefaultsInjector;
import org.apache.maven.project.injection.ProfileInjector;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.apache.maven.project.path.PathTranslator;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.project.validation.ModelValidator;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultMavenProjectBuilder
extends AbstractLogEnabled
implements MavenProjectBuilder,
Initializable,
Contextualizable {
    private PlexusContainer container;
    protected MavenProfilesBuilder profilesBuilder;
    protected ArtifactResolver artifactResolver;
    protected ArtifactMetadataSource artifactMetadataSource;
    private ArtifactFactory artifactFactory;
    private ModelInheritanceAssembler modelInheritanceAssembler;
    private ProfileInjector profileInjector;
    private ModelValidator validator;
    private Map rawProjectCache = new HashMap();
    private Map processedProjectCache = new HashMap();
    private MavenXpp3Reader modelReader;
    private PathTranslator pathTranslator;
    private ModelDefaultsInjector modelDefaultsInjector;
    private ModelInterpolator modelInterpolator;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private WagonManager wagonManager;
    public static final String MAVEN_MODEL_VERSION = "4.0.0";
    static /* synthetic */ Class class$org$apache$maven$project$DefaultMavenProjectBuilder;

    public void initialize() {
        this.modelReader = new MavenXpp3Reader();
    }

    public MavenProject build(File projectDescriptor, ArtifactRepository localRepository, ProfileManager profileManager) throws ProjectBuildingException {
        return this.buildFromSourceFileInternal(projectDescriptor, localRepository, profileManager, true);
    }

    public MavenProject build(File projectDescriptor, ArtifactRepository localRepository, ProfileManager profileManager, boolean checkDistributionManagementStatus) throws ProjectBuildingException {
        return this.buildFromSourceFileInternal(projectDescriptor, localRepository, profileManager, checkDistributionManagementStatus);
    }

    public MavenProject buildFromRepository(Artifact artifact, List remoteArtifactRepositories, ArtifactRepository localRepository, boolean allowStubModel) throws ProjectBuildingException {
        String cacheKey = DefaultMavenProjectBuilder.createCacheKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        MavenProject project = (MavenProject)this.processedProjectCache.get(cacheKey);
        if (project != null) {
            return project;
        }
        Model model = this.findModelFromRepository(artifact, remoteArtifactRepositories, localRepository, allowStubModel);
        return this.buildInternal("Artifact [" + artifact + "]", model, localRepository, remoteArtifactRepositories, null, null, false);
    }

    public MavenProject buildFromRepository(Artifact artifact, List remoteArtifactRepositories, ArtifactRepository localRepository) throws ProjectBuildingException {
        return this.buildFromRepository(artifact, remoteArtifactRepositories, localRepository, true);
    }

    public MavenProject buildStandaloneSuperProject(ArtifactRepository localRepository) throws ProjectBuildingException {
        DefaultProfileManager profileManager = new DefaultProfileManager(this.container);
        return this.buildStandaloneSuperProject(localRepository, profileManager);
    }

    public MavenProject buildStandaloneSuperProject(ArtifactRepository localRepository, ProfileManager profileManager) throws ProjectBuildingException {
        Model superModel = this.getSuperModel();
        superModel.setGroupId("org.apache.maven");
        superModel.setArtifactId("super-pom");
        superModel.setVersion("2.0");
        if (profileManager == null) {
            profileManager = new DefaultProfileManager(this.container);
        }
        profileManager.addProfiles(superModel.getProfiles());
        String projectId = this.safeVersionlessKey("org.apache.maven", "super-pom");
        List activeProfiles = this.injectActiveProfiles(profileManager, superModel);
        MavenProject project = new MavenProject(superModel);
        project.setManagedVersionMap(this.createManagedVersionMap(projectId, superModel.getDependencyManagement(), null));
        project.setActiveProfiles(activeProfiles);
        project.setOriginalModel(superModel);
        try {
            project = this.processProjectLogic("<Super-POM>", project, null, null, true);
            project.setExecutionRoot(true);
            return project;
        }
        catch (ModelInterpolationException e2) {
            throw new ProjectBuildingException(projectId, e2.getMessage(), e2);
        }
        catch (InvalidRepositoryException e3) {
            throw new ProjectBuildingException(projectId, e3.getMessage(), e3);
        }
    }

    public MavenProject buildWithDependencies(File projectDescriptor, ArtifactRepository localRepository, ProfileManager profileManager) throws ProjectBuildingException, ArtifactResolutionException, ArtifactNotFoundException {
        return this.buildWithDependencies(projectDescriptor, localRepository, profileManager, null);
    }

    public MavenProject buildWithDependencies(File projectDescriptor, ArtifactRepository localRepository, ProfileManager profileManager, TransferListener transferListener) throws ProjectBuildingException, ArtifactResolutionException, ArtifactNotFoundException {
        MavenProject project = this.build(projectDescriptor, localRepository, profileManager);
        Artifact projectArtifact = project.getArtifact();
        String projectId = this.safeVersionlessKey(project.getGroupId(), project.getArtifactId());
        Map managedVersions = project.getManagedVersionMap();
        this.ensureMetadataSourceIsInitialized();
        try {
            project.setDependencyArtifacts(project.createArtifacts(this.artifactFactory, null, null));
        }
        catch (InvalidDependencyVersionException e2) {
            throw new ProjectBuildingException(projectId, "Unable to build project due to an invalid dependency version: " + e2.getMessage(), e2);
        }
        if (transferListener != null) {
            this.wagonManager.setDownloadMonitor(transferListener);
        }
        ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(project.getDependencyArtifacts(), projectArtifact, managedVersions, localRepository, project.getRemoteArtifactRepositories(), this.artifactMetadataSource);
        project.setArtifacts(result.getArtifacts());
        return project;
    }

    private void ensureMetadataSourceIsInitialized() throws ProjectBuildingException {
        if (this.artifactMetadataSource == null) {
            try {
                this.artifactMetadataSource = (ArtifactMetadataSource)this.container.lookup(ArtifactMetadataSource.ROLE);
            }
            catch (ComponentLookupException e2) {
                throw new ProjectBuildingException("all", "Cannot lookup metadata source for building the project.", e2);
            }
        }
    }

    private Map createManagedVersionMap(String projectId, DependencyManagement dependencyManagement, MavenProject parent) throws ProjectBuildingException {
        List deps;
        Map map = null;
        if (dependencyManagement != null && (deps = dependencyManagement.getDependencies()) != null && deps.size() > 0) {
            map = new ManagedVersionMap(map);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Adding managed depedendencies for " + projectId);
            }
            Iterator i = dependencyManagement.getDependencies().iterator();
            while (i.hasNext()) {
                Dependency d = (Dependency)i.next();
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec(d.getVersion());
                    Artifact artifact = this.artifactFactory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope(), d.isOptional());
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("  " + artifact);
                    }
                    if (null != d.getExclusions() && !d.getExclusions().isEmpty()) {
                        ArrayList<String> exclusions = new ArrayList<String>();
                        Iterator exclItr = d.getExclusions().iterator();
                        while (exclItr.hasNext()) {
                            Exclusion e2 = (Exclusion)exclItr.next();
                            exclusions.add(e2.getGroupId() + ":" + e2.getArtifactId());
                        }
                        ExcludesArtifactFilter eaf = new ExcludesArtifactFilter(exclusions);
                        artifact.setDependencyFilter(eaf);
                    } else {
                        artifact.setDependencyFilter(null);
                    }
                    map.put(d.getManagementKey(), artifact);
                }
                catch (InvalidVersionSpecificationException e3) {
                    throw new ProjectBuildingException(projectId, "Unable to parse version '" + d.getVersion() + "' for dependency '" + d.getManagementKey() + "': " + e3.getMessage(), e3);
                }
            }
        } else if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        return map;
    }

    private MavenProject buildFromSourceFileInternal(File projectDescriptor, ArtifactRepository localRepository, ProfileManager profileManager, boolean checkDistributionManagementStatus) throws ProjectBuildingException {
        Model model = this.readModel("unknown", projectDescriptor, true);
        MavenProject project = this.buildInternal(projectDescriptor.getAbsolutePath(), model, localRepository, this.buildArtifactRepositories(this.getSuperModel()), projectDescriptor, profileManager, true);
        if (checkDistributionManagementStatus && project.getDistributionManagement() != null && project.getDistributionManagement().getStatus() != null) {
            String projectId = this.safeVersionlessKey(project.getGroupId(), project.getArtifactId());
            throw new ProjectBuildingException(projectId, "Invalid project file: distribution status must not be specified for a project outside of the repository");
        }
        return project;
    }

    private Model findModelFromRepository(Artifact artifact, List remoteArtifactRepositories, ArtifactRepository localRepository, boolean allowStubModel) throws ProjectBuildingException {
        Model model;
        Artifact projectArtifact;
        if ("pom".equals(artifact.getType())) {
            projectArtifact = artifact;
        } else {
            this.getLogger().warn("Attempting to build MavenProject instance for Artifact of type: " + artifact.getType() + "; constructing POM artifact instead.");
            projectArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope());
        }
        String projectId = ArtifactUtils.versionlessKey(projectArtifact);
        try {
            this.artifactResolver.resolve(projectArtifact, remoteArtifactRepositories, localRepository);
            File file = projectArtifact.getFile();
            model = this.readModel(projectId, file, false);
            String downloadUrl = null;
            ArtifactStatus status = ArtifactStatus.NONE;
            DistributionManagement distributionManagement = model.getDistributionManagement();
            if (distributionManagement != null) {
                downloadUrl = distributionManagement.getDownloadUrl();
                status = ArtifactStatus.valueOf(distributionManagement.getStatus());
            }
            this.checkStatusAndUpdate(projectArtifact, status, file, remoteArtifactRepositories, localRepository);
            if (downloadUrl != null) {
                projectArtifact.setDownloadUrl(downloadUrl);
            } else {
                projectArtifact.setDownloadUrl(model.getUrl());
            }
        }
        catch (ArtifactResolutionException e2) {
            throw new ProjectBuildingException(projectId, "Error getting POM for '" + projectId + "' from the repository: " + e2.getMessage(), e2);
        }
        catch (ArtifactNotFoundException e3) {
            if (allowStubModel) {
                this.getLogger().debug("Artifact not found - using stub model: " + e3.getMessage());
                model = this.createStubModel(projectArtifact);
            }
            throw new ProjectBuildingException(projectId, "POM '" + projectId + "' not found in repository: " + e3.getMessage(), e3);
        }
        return model;
    }

    private void checkStatusAndUpdate(Artifact projectArtifact, ArtifactStatus status, File file, List remoteArtifactRepositories, ArtifactRepository localRepository) throws ArtifactNotFoundException {
        if (!projectArtifact.isSnapshot() && status.compareTo(ArtifactStatus.DEPLOYED) < 0) {
            ArtifactRepositoryPolicy policy = new ArtifactRepositoryPolicy();
            policy.setUpdatePolicy("never");
            if (policy.checkOutOfDate(new Date(file.lastModified()))) {
                this.getLogger().info(projectArtifact.getArtifactId() + ": updating metadata due to status of '" + status + "'");
                try {
                    projectArtifact.setResolved(false);
                    this.artifactResolver.resolveAlways(projectArtifact, remoteArtifactRepositories, localRepository);
                }
                catch (ArtifactResolutionException e2) {
                    this.getLogger().warn("Error updating POM - using existing version");
                    this.getLogger().debug("Cause", e2);
                }
                catch (ArtifactNotFoundException e3) {
                    this.getLogger().warn("Error updating POM - not found. Removing local copy.");
                    this.getLogger().debug("Cause", e3);
                    file.delete();
                    throw e3;
                }
            }
        }
    }

    private Model createStubModel(Artifact projectArtifact) {
        this.getLogger().debug("Using defaults for missing POM " + projectArtifact);
        Model model = new Model();
        model.setModelVersion(MAVEN_MODEL_VERSION);
        model.setArtifactId(projectArtifact.getArtifactId());
        model.setGroupId(projectArtifact.getGroupId());
        model.setVersion(projectArtifact.getVersion());
        model.setPackaging(projectArtifact.getType());
        model.setDistributionManagement(new DistributionManagement());
        model.getDistributionManagement().setStatus(ArtifactStatus.GENERATED.toString());
        return model;
    }

    private MavenProject buildInternal(String pomLocation, Model model, ArtifactRepository localRepository, List parentSearchRepositories, File projectDescriptor, ProfileManager externalProfileManager, boolean strict) throws ProjectBuildingException {
        String cacheKey;
        MavenProject processedParent;
        MavenProject rawParent;
        List activeExternalProfiles;
        File projectDir = null;
        if (projectDescriptor != null) {
            projectDir = projectDescriptor.getAbsoluteFile().getParentFile();
        }
        Model superModel = this.getSuperModel();
        DefaultProfileManager superProjectProfileManager = externalProfileManager instanceof DefaultProfileManager ? new DefaultProfileManager(this.container, ((DefaultProfileManager)externalProfileManager).getSystemProperties()) : new DefaultProfileManager(this.container);
        superProjectProfileManager.addProfiles(superModel.getProfiles());
        List activeProfiles = this.injectActiveProfiles(superProjectProfileManager, superModel);
        MavenProject superProject = new MavenProject(superModel);
        superProject.setActiveProfiles(activeProfiles);
        LinkedList lineage = new LinkedList();
        LinkedHashSet<ArtifactRepository> aggregatedRemoteWagonRepositories = new LinkedHashSet<ArtifactRepository>();
        String projectId = this.safeVersionlessKey(model.getGroupId(), model.getArtifactId());
        try {
            activeExternalProfiles = externalProfileManager != null ? externalProfileManager.getActiveProfiles() : Collections.EMPTY_LIST;
        }
        catch (ProfileActivationException e2) {
            throw new ProjectBuildingException(projectId, "Failed to calculate active external profiles.", e2);
        }
        Iterator i = activeExternalProfiles.iterator();
        while (i.hasNext()) {
            org.apache.maven.model.Profile externalProfile = (org.apache.maven.model.Profile)i.next();
            Iterator repoIterator = externalProfile.getRepositories().iterator();
            while (repoIterator.hasNext()) {
                Repository mavenRepo = (Repository)repoIterator.next();
                ArtifactRepository artifactRepo = null;
                try {
                    artifactRepo = ProjectUtils.buildArtifactRepository(mavenRepo, this.artifactRepositoryFactory, this.container);
                }
                catch (InvalidRepositoryException e3) {
                    throw new ProjectBuildingException(projectId, e3.getMessage(), e3);
                }
                aggregatedRemoteWagonRepositories.add(artifactRepo);
            }
        }
        Model originalModel = ModelUtils.cloneModel(model);
        MavenProject project = null;
        try {
            project = this.assembleLineage(model, lineage, localRepository, projectDir, parentSearchRepositories, aggregatedRemoteWagonRepositories, externalProfileManager, strict);
        }
        catch (InvalidRepositoryException e4) {
            throw new ProjectBuildingException(projectId, e4.getMessage(), e4);
        }
        project.setOriginalModel(originalModel);
        this.rawProjectCache.put(DefaultMavenProjectBuilder.createCacheKey(project.getGroupId(), project.getArtifactId(), project.getVersion()), new MavenProject(project));
        MavenProject previousProject = superProject;
        Model previous = superProject.getModel();
        Iterator i2 = lineage.iterator();
        while (i2.hasNext()) {
            MavenProject currentProject = (MavenProject)i2.next();
            Model current = currentProject.getModel();
            String pathAdjustment = null;
            try {
                pathAdjustment = previousProject.getModulePathAdjustment(currentProject);
            }
            catch (IOException e5) {
                this.getLogger().debug("Cannot determine whether " + currentProject.getId() + " is a module of " + previousProject.getId() + ". Reason: " + e5.getMessage(), e5);
            }
            this.modelInheritanceAssembler.assembleModelInheritance(current, previous, pathAdjustment);
            previous = current;
            previousProject = currentProject;
        }
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>(aggregatedRemoteWagonRepositories);
        List superRepositories = this.buildArtifactRepositories(superModel);
        Iterator i3 = superRepositories.iterator();
        while (i3.hasNext()) {
            ArtifactRepository repository = (ArtifactRepository)i3.next();
            if (repositories.contains(repository)) continue;
            repositories.add(repository);
        }
        try {
            project = this.processProjectLogic(pomLocation, project, externalProfileManager, projectDir, strict);
        }
        catch (ModelInterpolationException e6) {
            throw new InvalidProjectModelException(projectId, pomLocation, e6.getMessage(), e6);
        }
        catch (InvalidRepositoryException e7) {
            throw new InvalidProjectModelException(projectId, pomLocation, e7.getMessage(), e7);
        }
        this.processedProjectCache.put(DefaultMavenProjectBuilder.createCacheKey(project.getGroupId(), project.getArtifactId(), project.getVersion()), project);
        if (projectDescriptor != null) {
            this.pathTranslator.alignToBaseDirectory(project.getModel(), projectDescriptor.getParentFile());
            Build build = project.getBuild();
            project.addCompileSourceRoot(build.getSourceDirectory());
            project.addScriptSourceRoot(build.getScriptSourceDirectory());
            project.addTestCompileSourceRoot(build.getTestSourceDirectory());
            project.setFile(projectDescriptor);
        }
        if ((rawParent = project.getParent()) != null && (processedParent = (MavenProject)this.processedProjectCache.get(cacheKey = DefaultMavenProjectBuilder.createCacheKey(rawParent.getGroupId(), rawParent.getArtifactId(), rawParent.getVersion()))) != null) {
            project.setParent(processedParent);
        }
        project.setManagedVersionMap(this.createManagedVersionMap(projectId, project.getDependencyManagement(), project.getParent()));
        return project;
    }

    private String safeVersionlessKey(String groupId, String artifactId) {
        String aid;
        String gid = groupId;
        if (StringUtils.isEmpty(gid)) {
            gid = "unknown";
        }
        if (StringUtils.isEmpty(aid = artifactId)) {
            aid = "unknown";
        }
        return ArtifactUtils.versionlessKey(gid, aid);
    }

    private List buildArtifactRepositories(Model model) throws ProjectBuildingException {
        try {
            return ProjectUtils.buildArtifactRepositories(model.getRepositories(), this.artifactRepositoryFactory, this.container);
        }
        catch (InvalidRepositoryException e2) {
            String projectId = this.safeVersionlessKey(model.getGroupId(), model.getArtifactId());
            throw new ProjectBuildingException(projectId, e2.getMessage(), e2);
        }
    }

    private MavenProject processProjectLogic(String pomLocation, MavenProject project, ProfileManager profileMgr, File projectDir, boolean strict) throws ProjectBuildingException, ModelInterpolationException, InvalidRepositoryException {
        Model model = project.getModel();
        ArrayList activeProfiles = project.getActiveProfiles();
        if (activeProfiles == null) {
            activeProfiles = new ArrayList();
        }
        List injectedProfiles = this.injectActiveProfiles(profileMgr, model);
        activeProfiles.addAll(injectedProfiles);
        HashMap<Object, Object> context = new HashMap<Object, Object>(System.getProperties());
        if (projectDir != null) {
            context.put("basedir", projectDir.getAbsolutePath());
        }
        context.put("build.directory", null);
        context.put("build.outputDirectory", null);
        context.put("build.testOutputDirectory", null);
        context.put("build.sourceDirectory", null);
        context.put("build.testSourceDirectory", null);
        model = this.modelInterpolator.interpolate(model, context, strict);
        this.modelDefaultsInjector.injectDefaults(model);
        MavenProject parentProject = project.getParent();
        Model originalModel = project.getOriginalModel();
        project = new MavenProject(model);
        project.setOriginalModel(originalModel);
        project.setActiveProfiles(activeProfiles);
        Artifact projectArtifact = this.artifactFactory.createBuildArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), project.getPackaging());
        project.setArtifact(projectArtifact);
        project.setPluginArtifactRepositories(ProjectUtils.buildArtifactRepositories(model.getPluginRepositories(), this.artifactRepositoryFactory, this.container));
        DistributionManagement dm = model.getDistributionManagement();
        if (dm != null) {
            ArtifactRepository repo = ProjectUtils.buildDeploymentArtifactRepository(dm.getRepository(), this.artifactRepositoryFactory, this.container);
            project.setReleaseArtifactRepository(repo);
            if (dm.getSnapshotRepository() != null) {
                repo = ProjectUtils.buildDeploymentArtifactRepository(dm.getSnapshotRepository(), this.artifactRepositoryFactory, this.container);
                project.setSnapshotArtifactRepository(repo);
            }
        }
        project.setParent(parentProject);
        if (parentProject != null) {
            Artifact parentArtifact = this.artifactFactory.createParentArtifact(parentProject.getGroupId(), parentProject.getArtifactId(), parentProject.getVersion());
            project.setParentArtifact(parentArtifact);
        }
        ModelValidationResult validationResult = this.validator.validate(model);
        String projectId = this.safeVersionlessKey(model.getGroupId(), model.getArtifactId());
        if (validationResult.getMessageCount() > 0) {
            throw new InvalidProjectModelException(projectId, pomLocation, "Failed to validate POM", validationResult);
        }
        project.setRemoteArtifactRepositories(ProjectUtils.buildArtifactRepositories(model.getRepositories(), this.artifactRepositoryFactory, this.container));
        project.setPluginArtifacts(this.createPluginArtifacts(projectId, project.getBuildPlugins()));
        project.setReportArtifacts(this.createReportArtifacts(projectId, project.getReportPlugins()));
        project.setExtensionArtifacts(this.createExtensionArtifacts(projectId, project.getBuildExtensions()));
        return project;
    }

    private MavenProject assembleLineage(Model model, LinkedList lineage, ArtifactRepository localRepository, File projectDir, List parentSearchRepositories, Set aggregatedRemoteWagonRepositories, ProfileManager externalProfileManager, boolean strict) throws ProjectBuildingException, InvalidRepositoryException {
        List activeProfiles;
        if (!model.getRepositories().isEmpty()) {
            List respositories = this.buildArtifactRepositories(model);
            Iterator it = respositories.iterator();
            while (it.hasNext()) {
                ArtifactRepository repository = (ArtifactRepository)it.next();
                if (aggregatedRemoteWagonRepositories.contains(repository)) continue;
                aggregatedRemoteWagonRepositories.add(repository);
            }
        }
        DefaultProfileManager profileManager = externalProfileManager != null && externalProfileManager instanceof DefaultProfileManager ? new DefaultProfileManager(this.container, ((DefaultProfileManager)externalProfileManager).getSystemProperties()) : new DefaultProfileManager(this.container);
        if (externalProfileManager != null) {
            profileManager.explicitlyActivate(externalProfileManager.getExplicitlyActivatedIds());
            profileManager.explicitlyDeactivate(externalProfileManager.getExplicitlyDeactivatedIds());
        }
        try {
            profileManager.addProfiles(model.getProfiles());
            this.loadProjectExternalProfiles(profileManager, projectDir);
            activeProfiles = this.injectActiveProfiles(profileManager, model);
        }
        catch (ProfileActivationException e2) {
            String projectId = this.safeVersionlessKey(model.getGroupId(), model.getArtifactId());
            throw new ProjectBuildingException(projectId, "Failed to activate local (project-level) build profiles: " + e2.getMessage(), e2);
        }
        MavenProject project = new MavenProject(model);
        project.setActiveProfiles(activeProfiles);
        lineage.addFirst(project);
        Parent parentModel = model.getParent();
        String projectId = this.safeVersionlessKey(model.getGroupId(), model.getArtifactId());
        if (parentModel != null) {
            if (StringUtils.isEmpty(parentModel.getGroupId())) {
                throw new ProjectBuildingException(projectId, "Missing groupId element from parent element");
            }
            if (StringUtils.isEmpty(parentModel.getArtifactId())) {
                throw new ProjectBuildingException(projectId, "Missing artifactId element from parent element");
            }
            if (parentModel.getGroupId().equals(model.getGroupId()) && parentModel.getArtifactId().equals(model.getArtifactId())) {
                throw new ProjectBuildingException(projectId, "Parent element is a duplicate of the current project ");
            }
            if (StringUtils.isEmpty(parentModel.getVersion())) {
                throw new ProjectBuildingException(projectId, "Missing version element from parent element");
            }
            File parentDescriptor = null;
            model = null;
            String parentKey = DefaultMavenProjectBuilder.createCacheKey(parentModel.getGroupId(), parentModel.getArtifactId(), parentModel.getVersion());
            MavenProject parentProject = (MavenProject)this.rawProjectCache.get(parentKey);
            if (parentProject != null) {
                model = ModelUtils.cloneModel(parentProject.getModel());
                parentDescriptor = parentProject.getFile();
            }
            String parentRelativePath = parentModel.getRelativePath();
            if (model == null && projectDir != null && StringUtils.isNotEmpty(parentRelativePath)) {
                parentDescriptor = new File(projectDir, parentRelativePath);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Searching for parent-POM: " + parentModel.getId() + " of project: " + project.getId() + " in relative path: " + parentRelativePath);
                }
                if (parentDescriptor.isDirectory()) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Path specified in <relativePath/> (" + parentRelativePath + ") is a directory. Searching for 'pom.xml' within this directory.");
                    }
                    if (!(parentDescriptor = new File(parentDescriptor, "pom.xml")).exists() && this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Parent-POM: " + parentModel.getId() + " for project: " + project.getId() + " cannot be loaded from relative path: " + parentDescriptor + "; path does not exist.");
                    }
                }
                if (parentDescriptor != null) {
                    try {
                        parentDescriptor = parentDescriptor.getCanonicalFile();
                    }
                    catch (IOException e3) {
                        this.getLogger().debug("Failed to canonicalize potential parent POM: '" + parentDescriptor + "'", e3);
                        parentDescriptor = null;
                    }
                }
                if (parentDescriptor != null && parentDescriptor.exists()) {
                    String candidateParentVersion;
                    Model candidateParent = this.readModel(projectId, parentDescriptor, strict);
                    String candidateParentGroupId = candidateParent.getGroupId();
                    if (candidateParentGroupId == null && candidateParent.getParent() != null) {
                        candidateParentGroupId = candidateParent.getParent().getGroupId();
                    }
                    if ((candidateParentVersion = candidateParent.getVersion()) == null && candidateParent.getParent() != null) {
                        candidateParentVersion = candidateParent.getParent().getVersion();
                    }
                    if (parentModel.getGroupId().equals(candidateParentGroupId) && parentModel.getArtifactId().equals(candidateParent.getArtifactId()) && parentModel.getVersion().equals(candidateParentVersion)) {
                        model = candidateParent;
                        this.getLogger().debug("Using parent-POM from the project hierarchy at: '" + parentModel.getRelativePath() + "' for project: " + project.getId());
                    } else {
                        this.getLogger().debug("Invalid parent-POM referenced by relative path '" + parentModel.getRelativePath() + "' in parent specification in " + project.getId() + ":" + "\n  Specified: " + parentModel.getId() + "\n  Found:     " + candidateParent.getId());
                    }
                } else if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Parent-POM: " + parentModel.getId() + " not found in relative path: " + parentRelativePath);
                }
            }
            Artifact parentArtifact = null;
            if (model == null) {
                parentDescriptor = null;
                ArrayList remoteRepositories = new ArrayList(aggregatedRemoteWagonRepositories);
                remoteRepositories.addAll(parentSearchRepositories);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Retrieving parent-POM: " + parentModel.getId() + " for project: " + project.getId() + " from the repository.");
                }
                parentArtifact = this.artifactFactory.createParentArtifact(parentModel.getGroupId(), parentModel.getArtifactId(), parentModel.getVersion());
                try {
                    model = this.findModelFromRepository(parentArtifact, remoteRepositories, localRepository, false);
                }
                catch (ProjectBuildingException e4) {
                    throw new ProjectBuildingException(project.getId(), "Cannot find parent: " + e4.getProjectId() + " for project: " + project.getId(), e4);
                }
            }
            if (model != null && !"pom".equals(model.getPackaging())) {
                throw new ProjectBuildingException(projectId, "Parent: " + model.getId() + " of project: " + projectId + " has wrong packaging: " + model.getPackaging() + ". Must be 'pom'.");
            }
            File parentProjectDir = null;
            if (parentDescriptor != null) {
                parentProjectDir = parentDescriptor.getParentFile();
            }
            MavenProject parent = this.assembleLineage(model, lineage, localRepository, parentProjectDir, parentSearchRepositories, aggregatedRemoteWagonRepositories, externalProfileManager, strict);
            parent.setFile(parentDescriptor);
            project.setParent(parent);
            project.setParentArtifact(parentArtifact);
        }
        return project;
    }

    private List injectActiveProfiles(ProfileManager profileManager, Model model) throws ProjectBuildingException {
        List activeProfiles;
        if (profileManager != null) {
            try {
                activeProfiles = profileManager.getActiveProfiles();
            }
            catch (ProfileActivationException e2) {
                String projectId = this.safeVersionlessKey(model.getGroupId(), model.getArtifactId());
                throw new ProjectBuildingException(projectId, e2.getMessage(), e2);
            }
            Iterator it = activeProfiles.iterator();
            while (it.hasNext()) {
                org.apache.maven.model.Profile profile = (org.apache.maven.model.Profile)it.next();
                this.profileInjector.inject(profile, model);
            }
        } else {
            activeProfiles = Collections.EMPTY_LIST;
        }
        return activeProfiles;
    }

    private void loadProjectExternalProfiles(ProfileManager profileManager, File projectDir) throws ProfileActivationException {
        if (projectDir != null) {
            try {
                ProfilesRoot root2 = this.profilesBuilder.buildProfiles(projectDir);
                if (root2 != null) {
                    List active = root2.getActiveProfiles();
                    if (active != null && !active.isEmpty()) {
                        profileManager.explicitlyActivate(root2.getActiveProfiles());
                    }
                    Iterator it = root2.getProfiles().iterator();
                    while (it.hasNext()) {
                        Profile rawProfile = (Profile)it.next();
                        org.apache.maven.model.Profile converted = ProfilesConversionUtils.convertFromProfileXmlProfile(rawProfile);
                        profileManager.addProfile(converted);
                    }
                }
            }
            catch (IOException e2) {
                throw new ProfileActivationException("Cannot read profiles.xml resource from directory: " + projectDir, e2);
            }
            catch (XmlPullParserException e3) {
                throw new ProfileActivationException("Cannot parse profiles.xml resource from directory: " + projectDir, e3);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Model readModel(String projectId, File file, boolean strict) throws ProjectBuildingException {
        Model model;
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            model = this.readModel(projectId, file.getAbsolutePath(), reader, strict);
        }
        catch (FileNotFoundException e2) {
            try {
                throw new ProjectBuildingException(projectId, "Could not find the model file '" + file.getAbsolutePath() + "'.", e2);
                catch (IOException e3) {
                    throw new ProjectBuildingException(projectId, "Failed to build model from file '" + file.getAbsolutePath() + "'.\nError: '" + e3.getLocalizedMessage() + "'", e3);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close(reader);
        return model;
    }

    private Model readModel(String projectId, String pomLocation, Reader reader, boolean strict) throws IOException, InvalidProjectModelException {
        StringWriter sw = new StringWriter();
        IOUtil.copy(reader, (Writer)sw);
        String modelSource = sw.toString();
        if (modelSource.indexOf("<modelVersion>4.0.0") < 0) {
            throw new InvalidProjectModelException(projectId, pomLocation, "Not a v4.0.0 POM.");
        }
        StringReader sReader = new StringReader(modelSource);
        try {
            return this.modelReader.read(sReader, strict);
        }
        catch (XmlPullParserException e2) {
            throw new InvalidProjectModelException(projectId, pomLocation, "Parse error reading POM. Reason: " + e2.getMessage(), e2);
        }
    }

    private Model readModel(String projectId, URL url, boolean strict) throws ProjectBuildingException {
        Model model;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(url.openStream());
            model = this.readModel(projectId, url.toExternalForm(), reader, strict);
        }
        catch (IOException e2) {
            try {
                throw new ProjectBuildingException(projectId, "Failed build model from URL '" + url.toExternalForm() + "'\nError: '" + e2.getLocalizedMessage() + "'", e2);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close(reader);
        return model;
    }

    private static String createCacheKey(String groupId, String artifactId, String version2) {
        return groupId + ":" + artifactId + ":" + version2;
    }

    protected Set createPluginArtifacts(String projectId, List plugins) throws ProjectBuildingException {
        HashSet<Artifact> pluginArtifacts = new HashSet<Artifact>();
        Iterator i = plugins.iterator();
        while (i.hasNext()) {
            Artifact artifact;
            Plugin p = (Plugin)i.next();
            String version2 = StringUtils.isEmpty(p.getVersion()) ? "RELEASE" : p.getVersion();
            try {
                artifact = this.artifactFactory.createPluginArtifact(p.getGroupId(), p.getArtifactId(), VersionRange.createFromVersionSpec(version2));
            }
            catch (InvalidVersionSpecificationException e2) {
                throw new ProjectBuildingException(projectId, "Unable to parse version '" + version2 + "' for plugin '" + ArtifactUtils.versionlessKey(p.getGroupId(), p.getArtifactId()) + "': " + e2.getMessage(), e2);
            }
            if (artifact == null) continue;
            pluginArtifacts.add(artifact);
        }
        return pluginArtifacts;
    }

    protected Set createReportArtifacts(String projectId, List reports) throws ProjectBuildingException {
        HashSet<Artifact> pluginArtifacts = new HashSet<Artifact>();
        if (reports != null) {
            Iterator i = reports.iterator();
            while (i.hasNext()) {
                Artifact artifact;
                ReportPlugin p = (ReportPlugin)i.next();
                String version2 = StringUtils.isEmpty(p.getVersion()) ? "RELEASE" : p.getVersion();
                try {
                    artifact = this.artifactFactory.createPluginArtifact(p.getGroupId(), p.getArtifactId(), VersionRange.createFromVersionSpec(version2));
                }
                catch (InvalidVersionSpecificationException e2) {
                    throw new ProjectBuildingException(projectId, "Unable to parse version '" + version2 + "' for report '" + ArtifactUtils.versionlessKey(p.getGroupId(), p.getArtifactId()) + "': " + e2.getMessage(), e2);
                }
                if (artifact == null) continue;
                pluginArtifacts.add(artifact);
            }
        }
        return pluginArtifacts;
    }

    protected Set createExtensionArtifacts(String projectId, List extensions) throws ProjectBuildingException {
        HashSet<Artifact> extensionArtifacts = new HashSet<Artifact>();
        if (extensions != null) {
            Iterator i = extensions.iterator();
            while (i.hasNext()) {
                Artifact artifact;
                Extension ext = (Extension)i.next();
                String version2 = StringUtils.isEmpty(ext.getVersion()) ? "RELEASE" : ext.getVersion();
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec(version2);
                    artifact = this.artifactFactory.createExtensionArtifact(ext.getGroupId(), ext.getArtifactId(), versionRange);
                }
                catch (InvalidVersionSpecificationException e2) {
                    throw new ProjectBuildingException(projectId, "Unable to parse version '" + version2 + "' for extension '" + ArtifactUtils.versionlessKey(ext.getGroupId(), ext.getArtifactId()) + "': " + e2.getMessage(), e2);
                }
                if (artifact == null) continue;
                extensionArtifacts.add(artifact);
            }
        }
        return extensionArtifacts;
    }

    private Model getSuperModel() throws ProjectBuildingException {
        URL url = (class$org$apache$maven$project$DefaultMavenProjectBuilder == null ? (class$org$apache$maven$project$DefaultMavenProjectBuilder = DefaultMavenProjectBuilder.class$("org.apache.maven.project.DefaultMavenProjectBuilder")) : class$org$apache$maven$project$DefaultMavenProjectBuilder).getResource("pom-4.0.0.xml");
        String projectId = this.safeVersionlessKey("org.apache.maven", "super-pom");
        return this.readModel(projectId, url, true);
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

