/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.slf4j.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XMLErrorLogger
implements ErrorHandler,
ErrorListener,
XMLReporter {
    private final Logger log;

    public XMLErrorLogger(Logger log2) {
        this.log = log2;
    }

    @Override
    public void warning(SAXParseException e2) {
        this.log.warn("XML parse warning in \"" + e2.getSystemId() + "\", line " + e2.getLineNumber() + ", column " + e2.getColumnNumber() + ": " + e2.getMessage());
    }

    @Override
    public void error(SAXParseException e2) throws SAXException {
        throw e2;
    }

    @Override
    public void fatalError(SAXParseException e2) throws SAXException {
        throw e2;
    }

    @Override
    public void warning(TransformerException e2) {
        this.log.warn(e2.getMessageAndLocation());
    }

    @Override
    public void error(TransformerException e2) throws TransformerException {
        throw e2;
    }

    @Override
    public void fatalError(TransformerException e2) throws TransformerException {
        throw e2;
    }

    @Override
    public void report(String message, String errorType, Object relatedInformation, Location loc) {
        StringBuilder sb = new StringBuilder("XML parser reported ").append(errorType);
        if (loc != null) {
            sb.append(" in \"").append(loc.getSystemId()).append("\", line ").append(loc.getLineNumber()).append(", column ").append(loc.getColumnNumber());
        }
        this.log.warn(sb.append(": ").append(message).toString());
    }
}

