/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.index;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.index.IndexingTask;
import org.dataone.cn.index.IndexingTaskList;
import org.dataone.cn.indexer.SolrIndexService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class App {
    public static String DOCUMENT_PARSERS = "documentParsers";
    public static String LOCKFILE = "/tmp/indexing/indexlock.lck";
    public static String TSTAMPFILE = "/tmp/indexing/indextstamp.txt";
    private static ApplicationContext context = null;
    private String springConfigFile = "/etc/dataone/indexing/application-context.xml";
    private String processingProperties = "/etc/dataone/indexing/index_processor.properties";
    private String taskListPath = "/tmp/indexing/index_tasks.txt";
    private String objectBasePath = "";
    public List<SolrIndexService> parserList = null;
    Log log = LogFactory.getLog(App.class);

    public static void main(String[] args) {
        File alock = new File(LOCKFILE);
        if (alock.exists()) {
            System.err.println("ERROR: Lock file " + LOCKFILE + " exists.");
            System.exit(1);
        }
        App app = new App();
        Options opps = app.getOptions();
        PosixParser parser = new PosixParser();
        CommandLine line = null;
        try {
            line = parser.parse(opps, args);
        }
        catch (ParseException exp) {
            System.out.println(exp.getMessage());
            App.printHelp(opps);
            System.exit(-1);
        }
        try {
            FileWriter flock = new FileWriter(LOCKFILE);
            flock.write("locked at: " + new Date().toString());
            flock.close();
            alock.deleteOnExit();
        }
        catch (IOException e2) {
            System.err.println("ERROR: Could not create lock file " + LOCKFILE);
            System.exit(2);
        }
        String configFile = line.getOptionValue("config", "/etc/dataone/indexing/application-context.xml");
        String taskFile = line.getOptionValue("tasks", "/tmp/indexing/index_tasks.txt");
        String base = line.getOptionValue("base", "");
        app.setSpringConfigFile(configFile);
        app.loadConfig();
        app.setTaskListPath(taskFile);
        app.setObjectBasePath(base);
        long youngestSysMeta = app.run();
        if (youngestSysMeta >= 0L) {
            try {
                FileWriter fts = new FileWriter(TSTAMPFILE);
                fts.write(youngestSysMeta + "\n");
                fts.close();
            }
            catch (IOException e3) {
                System.err.println("ERROR: Could not create timestamp file " + TSTAMPFILE);
            }
        }
    }

    public void loadConfig() {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(this.processingProperties));
            this.taskListPath = props.getProperty("taskListPath", this.taskListPath);
            this.objectBasePath = props.getProperty("objectBasePath", this.objectBasePath);
        }
        catch (IOException e2) {
            this.log.info(e2.getMessage());
        }
    }

    public IndexingTaskList loadTasks(String sourcePath) {
        IndexingTaskList tasks = new IndexingTaskList(sourcePath, this.objectBasePath);
        return tasks;
    }

    public long run() {
        context = this.getContext();
        this.parserList = (List)context.getBean(DOCUMENT_PARSERS);
        SolrIndexService parser = this.parserList.get(0);
        IndexingTaskList tasks = this.loadTasks(this.taskListPath);
        long youngestTask = -1L;
        for (int i = 0; i < tasks.size(); ++i) {
            IndexingTask task = (IndexingTask)tasks.get(i);
            if (task.dateSysmModified > youngestTask) {
                youngestTask = task.dateSysmModified;
            }
            this.log.info("Processing PID, sys, object = " + task.pid + ", " + task.sysMetaPath + ", " + task.objectPath);
            try {
                FileInputStream smdStream = new FileInputStream(task.sysMetaPath);
                parser.insertIntoIndex(task.pid, smdStream, task.objectPath);
                this.log.info("Processing complete for PID = " + task.pid);
                continue;
            }
            catch (Exception e2) {
                this.log.info("Processing failed for PID = " + task.pid);
                this.log.error(e2.getMessage());
            }
        }
        return youngestTask;
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("indexer", options);
    }

    public Options getOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("spring configuration file");
        Option spring = OptionBuilder.create("config");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Full path to the tasks list file (/tmp/indexing/index_tasks.txt)");
        Option files = OptionBuilder.create("tasks");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Filesystem root that config and tasks are relative to (null)");
        Option base = OptionBuilder.create("base");
        spring.setRequired(false);
        files.setRequired(false);
        options = options.addOption(spring).addOption(files).addOption(base);
        return options;
    }

    public ApplicationContext getContext() {
        if (context == null) {
            try {
                context = new FileSystemXmlApplicationContext(this.springConfigFile);
            }
            catch (Exception e2) {
                this.log.info(e2.getMessage());
                this.log.info("Falling back to configuration included in jar file.");
                context = new ClassPathXmlApplicationContext("application-context.xml");
            }
        }
        return context;
    }

    public void setSpringConfigFile(String springConfigFile) {
        this.springConfigFile = springConfigFile;
    }

    public void setTaskListPath(String taskListPath) {
        this.taskListPath = taskListPath;
    }

    public void setObjectBasePath(String objectBasePath) {
        this.objectBasePath = objectBasePath;
    }
}

