/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.annotation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.ModelFactory;
import org.dataone.cn.index.util.PerformanceLogger;
import org.dataone.cn.indexer.AbstractStubMergingSubprocessor;
import org.dataone.cn.indexer.D1IndexerSolrClient;
import org.dataone.cn.indexer.annotation.SparqlField;
import org.dataone.cn.indexer.annotation.TripleStoreService;
import org.dataone.cn.indexer.parser.IDocumentSubprocessor;
import org.dataone.cn.indexer.parser.IDocumentSubprocessorV2;
import org.dataone.cn.indexer.parser.ISolrDataField;
import org.dataone.cn.indexer.parser.SubprocessorUtility;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.springframework.beans.factory.annotation.Autowired;

public class RdfXmlSubprocessor
extends AbstractStubMergingSubprocessor
implements IDocumentSubprocessor,
IDocumentSubprocessorV2 {
    private static Log log = LogFactory.getLog(RdfXmlSubprocessor.class);
    private static PerformanceLogger perfLog = PerformanceLogger.getInstance();
    private List<String> matchDocuments = null;
    private List<ISolrDataField> fieldList = new ArrayList<ISolrDataField>();
    private List<String> fieldsToMerge = new ArrayList<String>();
    @Autowired
    private D1IndexerSolrClient d1IndexerSolrClient = null;
    @Autowired
    private String solrQueryUri = null;
    @Autowired
    private SubprocessorUtility processorUtility;

    @Override
    public boolean canProcess(String formatId) {
        return this.matchDocuments.contains(formatId);
    }

    public List<String> getMatchDocuments() {
        return this.matchDocuments;
    }

    public void setMatchDocuments(List<String> matchDocuments) {
        this.matchDocuments = matchDocuments;
    }

    public List<ISolrDataField> getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(List<ISolrDataField> fieldList) {
        this.fieldList = fieldList;
    }

    @Override
    public Map<String, SolrDoc> processDocument(String identifier, Map<String, SolrDoc> docs, InputStream is) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("INCOMING DOCS to processDocument(): ");
            this.serializeDocuments(docs);
        }
        Map<String, SolrDoc> processedDocsMap = this.process(identifier, is);
        SolrDoc resourceMapDoc = docs.get(identifier);
        processedDocsMap.put(identifier, resourceMapDoc);
        if (log.isTraceEnabled()) {
            log.trace("PREMERGED DOCS from processDocument(): ");
            this.serializeDocuments(processedDocsMap);
        }
        Map<String, SolrDoc> mergedDocs = this.mergeDocs(docs, processedDocsMap);
        if (log.isTraceEnabled()) {
            log.trace("OUTGOING DOCS from processDocument(): ");
            this.serializeDocuments(mergedDocs);
        }
        return mergedDocs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeDocuments(Map<String, SolrDoc> docs) {
        StringBuilder documents = new StringBuilder();
        documents.append("<docs>");
        for (SolrDoc doc : docs.values()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                doc.serialize(baos, "UTF-8");
            }
            catch (IOException e2) {
                log.trace("Couldn't serialize documents: " + e2.getMessage());
            }
            try {
                documents.append(baos.toString());
            }
            finally {
                IOUtils.closeQuietly(baos);
            }
        }
        documents.append("</docs>");
        log.trace(documents.toString());
    }

    private Map<String, SolrDoc> process(String indexDocId, InputStream is) throws Exception {
        log.debug("process(..): entering method...");
        long start = System.currentTimeMillis();
        Map<String, SolrDoc> documentsToIndex = this.parseDocument(indexDocId, is);
        long getStart = System.currentTimeMillis();
        Map<String, SolrDoc> existingDocuments = this.getSolrDocs(documentsToIndex.keySet());
        perfLog.log("RdfXmlSubprocess.process get existing solr docs ", System.currentTimeMillis() - getStart);
        Map<String, SolrDoc> mergedDocuments = this.mergeDocs(documentsToIndex, existingDocuments);
        perfLog.log("RdfXmlSubprocess.process() total take ", System.currentTimeMillis() - start);
        return mergedDocuments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, SolrDoc> parseDocument(String indexDocId, InputStream is) throws Exception {
        HashMap<String, SolrDoc> documentsToIndex = new HashMap<String, SolrDoc>();
        long start = System.currentTimeMillis();
        Dataset dataset = TripleStoreService.getInstance().getDataset();
        log.debug("parseDocument(..): Got dataset from TripleStoreService");
        try {
            perfLog.log("RdfXmlSubprocess.parseDocument gets a dataset from triple store service ", System.currentTimeMillis() - start);
            String name = indexDocId;
            String scheme = null;
            try {
                URI nameURI = new URI(indexDocId);
                scheme = nameURI.getScheme();
            }
            catch (URISyntaxException use) {
                name = "https://cn.dataone.org/cn/v1/resolve/" + indexDocId;
            }
            if (scheme == null || scheme.isEmpty()) {
                name = "https://cn.dataone.org/cn/v1/resolve/" + indexDocId;
            }
            long startOntModel = System.currentTimeMillis();
            boolean loaded = dataset.containsNamedModel(name);
            if (!loaded) {
                OntModel ontModel = ModelFactory.createOntologyModel();
                ontModel.read(is, name);
                dataset.addNamedModel(name, ontModel);
            }
            perfLog.log("RdfXmlSubprocess.process adds ont-model ", System.currentTimeMillis() - startOntModel);
            log.debug("process(..): added ont-model...");
            long startField = System.currentTimeMillis();
            for (ISolrDataField field : this.fieldList) {
                long filed = System.currentTimeMillis();
                String q = null;
                if (field instanceof SparqlField) {
                    q = ((SparqlField)field).getQuery();
                    q = q.replaceAll("\\$GRAPH_NAME", name);
                    Query query2 = QueryFactory.create(q);
                    if (log.isTraceEnabled()) {
                        log.trace("Executing SPARQL query:\n" + query2.toString());
                    }
                    QueryExecution qexec = QueryExecutionFactory.create(query2, dataset);
                    ResultSet results = qexec.execSelect();
                    while (results.hasNext()) {
                        SolrDoc solrDoc = null;
                        QuerySolution solution = results.next();
                        if (log.isTraceEnabled()) {
                            log.trace(solution.toString());
                        }
                        if (solution.contains("pid")) {
                            String id = solution.getLiteral("pid").getString();
                            boolean statementAuthorized = true;
                            if (!statementAuthorized) continue;
                            solrDoc = (SolrDoc)documentsToIndex.get(id);
                            if (solrDoc == null) {
                                solrDoc = new SolrDoc();
                                solrDoc.addField(new SolrElementField("id", id));
                                documentsToIndex.put(id, solrDoc);
                            }
                        }
                        if (!solution.contains(field.getName())) continue;
                        String value = solution.get(field.getName()).toString();
                        SolrElementField f = new SolrElementField(field.getName(), value);
                        if (solrDoc.hasFieldWithValue(f.getName(), f.getValue())) continue;
                        solrDoc.addField(f);
                    }
                }
                perfLog.log("RdfXmlSubprocess.parseDocument process the field " + field.getName(), System.currentTimeMillis() - filed);
            }
            perfLog.log("RdfXmlSubprocess.parseDocument process the fields total ", System.currentTimeMillis() - startField);
        }
        finally {
            try {
                TripleStoreService.getInstance().destoryDataset(dataset);
            }
            catch (Exception e2) {
                log.warn("A tdb directory can't be removed since " + e2.getMessage(), e2);
            }
        }
        return documentsToIndex;
    }

    private Map<String, SolrDoc> getSolrDocs(Set<String> ids) throws Exception {
        log.debug("getSolrDocs(..): entered method...");
        HashMap<String, SolrDoc> list = new HashMap<String, SolrDoc>();
        if (ids != null) {
            for (String id : ids) {
                SolrDoc doc = this.d1IndexerSolrClient.retrieveDocumentFromSolrServer(id, this.solrQueryUri);
                if (doc == null) continue;
                list.put(id, doc);
            }
        }
        return list;
    }

    private Map<String, SolrDoc> mergeDocs(Map<String, SolrDoc> pending, Map<String, SolrDoc> existing) throws Exception {
        long start = System.currentTimeMillis();
        HashMap<String, SolrDoc> merged = new HashMap<String, SolrDoc>();
        for (String id : pending.keySet()) {
            SolrDoc pendingDoc = pending.get(id);
            SolrDoc existingDoc = existing.get(id);
            SolrDoc mergedDoc = new SolrDoc();
            if (existingDoc != null) {
                for (SolrElementField field : existingDoc.getFieldList()) {
                    mergedDoc.addField(field);
                }
            }
            for (SolrElementField field : pendingDoc.getFieldList()) {
                if (field.getName().equals("id") && mergedDoc.hasField("id") || mergedDoc.hasFieldWithValue(field.getName(), field.getValue())) continue;
                mergedDoc.addField(field);
            }
            merged.put(id, mergedDoc);
        }
        for (String existingId : existing.keySet()) {
            if (merged.containsKey(existingId)) continue;
            merged.put(existingId, existing.get(existingId));
        }
        if (log.isTraceEnabled()) {
            log.trace("MERGED DOCS with existing from the Solr index: ");
            this.serializeDocuments(merged);
        }
        perfLog.log("RdfXmlSubprocess.merge total ", System.currentTimeMillis() - start);
        return merged;
    }

    @Override
    public SolrDoc mergeWithIndexedDocument(SolrDoc indexDocument) throws IOException, EncoderException, XPathExpressionException {
        return this.processorUtility.mergeWithIndexedDocument(indexDocument, this.fieldsToMerge);
    }

    public List<String> getFieldsToMerge() {
        return this.fieldsToMerge;
    }

    public void setFieldsToMerge(List<String> fieldsToMerge) {
        this.fieldsToMerge = fieldsToMerge;
    }
}

