/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.convert;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dataone.cn.indexer.convert.IConverter;

public class FgdcDateConverter
implements IConverter {
    private static TimeZone OUTPUT_TIMEZONE = TimeZone.getTimeZone("Zulu");
    private static final String OUTPUT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String[] DATE_PATTERNS = new String[]{"\\d{4}", "\\d{4}[01]\\d", "\\d{4}[01]\\d[0123]\\d", "\\d{9}", "\\d{4} onwards", "\\d{4} and \\d{4}", "\\d{4}[/|-]\\d{4}", "\\w* \\d{4}", "\\w*, \\d{4}", "\\d{4} on", "\\d{4}-[01]\\d-[0123]\\d", "\\d{4}- \\[unpublished annual reports\\]"};
    private List<Pattern> patterns = new ArrayList<Pattern>();

    public FgdcDateConverter() {
        for (String datePattern : DATE_PATTERNS) {
            Pattern pattern = Pattern.compile(datePattern);
            this.patterns.add(pattern);
        }
    }

    @Override
    public String convert(String data) {
        Date date2 = this.textToDate(data);
        if (date2 != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(OUTPUT_DATE_FORMAT);
            sdf.setTimeZone(OUTPUT_TIMEZONE);
            String outputDateFormat = sdf.format(date2.getTime());
            return outputDateFormat;
        }
        return "";
    }

    public Date textToDate(String dateString) {
        Date convertedDate = null;
        Boolean validPattern = false;
        Boolean convertMonth = false;
        String defaultDay = "01";
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(dateString);
            if (!matcher.matches()) continue;
            validPattern = true;
            if (!pattern.pattern().substring(0, 3).equals("\\w*")) break;
            convertMonth = true;
            break;
        }
        if (validPattern.booleanValue()) {
            int dateStringLen = dateString.length();
            String extractedYear = "";
            String extractedMonth = "";
            String extractedDay = "";
            if (convertMonth.booleanValue()) {
                extractedYear = dateString.substring(dateStringLen - 4, dateStringLen);
                SimpleDateFormat formatter = new SimpleDateFormat("MMM");
                try {
                    Date tempDate = formatter.parse(dateString.substring(0, 3));
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(tempDate);
                    extractedMonth = Integer.toString(cal.get(2) + 1);
                }
                catch (ParseException e2) {
                    return convertedDate;
                }
                extractedDay = defaultDay;
            } else {
                switch (dateStringLen) {
                    case 4: {
                        extractedYear = dateString.substring(0, 4);
                        extractedMonth = "01";
                        extractedDay = defaultDay;
                        break;
                    }
                    case 6: {
                        extractedYear = dateString.substring(0, 4);
                        extractedMonth = dateString.substring(4, 6);
                        extractedDay = defaultDay;
                        break;
                    }
                    case 7: {
                        extractedYear = dateString.substring(0, 4);
                        extractedMonth = "01";
                        extractedDay = defaultDay;
                        break;
                    }
                    case 8: {
                        extractedYear = dateString.substring(0, 4);
                        extractedMonth = dateString.substring(4, 6);
                        extractedDay = dateString.substring(6, 8);
                        break;
                    }
                    case 9: {
                        extractedYear = dateString.substring(0, 4);
                        extractedMonth = "01";
                        extractedDay = defaultDay;
                        break;
                    }
                    case 10: {
                        extractedYear = dateString.substring(0, 4);
                        extractedMonth = dateString.substring(5, 7);
                        extractedDay = dateString.substring(8, 10);
                        break;
                    }
                    case 12: {
                        extractedYear = dateString.substring(0, 4);
                        extractedMonth = "01";
                        extractedDay = defaultDay;
                        break;
                    }
                    case 13: {
                        extractedYear = dateString.substring(0, 4);
                        extractedMonth = "01";
                        extractedDay = defaultDay;
                        break;
                    }
                    case 34: {
                        extractedYear = dateString.substring(0, 4);
                        extractedMonth = "01";
                        extractedDay = defaultDay;
                    }
                }
            }
            String extractedDate = extractedYear + "-" + extractedMonth + "-" + extractedDay + " 00:00:00+0000";
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                convertedDate = formatter.parse(extractedDate);
            }
            catch (ParseException e3) {
                return convertedDate;
            }
        }
        return convertedDate;
    }
}

