/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.dataone.cn.indexer.solrhttp.SolrSchema;

public class UpdateAssembler {
    private static Logger _log = Logger.getLogger(UpdateAssembler.class);
    private HashMap<String, Long> currentVersion = new HashMap();
    private HashMap<String, SolrDoc> existingMap = new HashMap();
    private TreeMap<String, List<SolrDoc>> updates = new TreeMap();
    private SolrSchema solrSchema;

    public UpdateAssembler(SolrSchema solrSchema) {
        this.solrSchema = solrSchema;
    }

    public void addToUpdate(String id, SolrDoc existing, SolrDoc newMaterial) {
        if (existing != null) {
            String versionString = existing.getFirstFieldValue("_version_");
            if (versionString != null) {
                Long version2 = Long.valueOf(versionString);
                if (!this.currentVersion.containsKey(id) || this.currentVersion.get(id) <= version2) {
                    this.currentVersion.put(id, version2);
                    this.existingMap.put(id, existing);
                }
            } else {
                String message = "_version_ field is somehow null.  If in production, look at the schema and SolrSchema class and SolrJClient#parseResponse for problems";
                _log.error("for id " + id + ": " + message);
                throw new RuntimeException(message);
            }
        }
        if (newMaterial != null) {
            if (!this.updates.containsKey(id)) {
                this.updates.put(id, new ArrayList());
            }
            this.updates.get(id).add(newMaterial);
        }
    }

    public List<SolrDoc> assembleUpdate(int startIndex) {
        ArrayList<SolrDoc> assembledUpdate = new ArrayList<SolrDoc>();
        if (_log.isDebugEnabled()) {
            _log.debug("entering assembleUpdate.(startIndex = " + startIndex + " / endIndex = " + (this.updates.keySet().size() - 1) + ")");
        }
        int i = 0;
        for (Map.Entry<String, List<SolrDoc>> n : this.updates.entrySet()) {
            String id = n.getKey();
            if (i >= startIndex) {
                if (_log.isDebugEnabled()) {
                    _log.debug(String.format("Consolidating for id %s, from existing version %s, with %d updates", id, this.currentVersion.get(id), n.getValue().size()));
                }
                SolrDoc collectingDoc = null;
                for (SolrDoc update2 : n.getValue()) {
                    collectingDoc = this.consolidateNewMaterial(id, collectingDoc, update2);
                }
                SolrDoc partialUpdate = this.createPartialUpdate(this.existingMap.get(id), collectingDoc);
                if (partialUpdate != null) {
                    assembledUpdate.add(partialUpdate);
                }
            }
            ++i;
        }
        return assembledUpdate;
    }

    protected SolrDoc consolidateNewMaterial(String id, SolrDoc consolidationTarget, SolrDoc newMaterial) {
        if (consolidationTarget == null) {
            if (this.existingMap.get(id) != null) {
                consolidationTarget = this.existingMap.get(id).clone();
            } else {
                if (newMaterial != null) {
                    return newMaterial.clone();
                }
                return null;
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug("  (the consolidation target for id " + id + " has " + consolidationTarget.getFieldList().size() + " elements.)");
        }
        Iterator<String> iterator = this.solrSchema.listSegments().iterator();
        block14: while (iterator.hasNext()) {
            String segment;
            switch (segment = iterator.next()) {
                case "sysmeta": 
                case "scimeta": 
                case "mn_service": {
                    if (this.getSegment(newMaterial, segment) == null || this.getSegment(newMaterial, segment).isEmpty()) break;
                    for (String fieldname : this.solrSchema.getAllSegmentFields(segment)) {
                        consolidationTarget.removeAllFields(fieldname);
                    }
                    for (SolrElementField sef : this.getSegment(newMaterial, segment)) {
                        consolidationTarget.addField(sef);
                    }
                    continue block14;
                }
                case "ore": 
                case "prov": 
                case "sem": {
                    if (this.getSegment(newMaterial, segment) == null || this.getSegment(newMaterial, segment).isEmpty()) break;
                    for (SolrElementField field : this.getSegment(newMaterial, segment)) {
                        if (this.solrSchema.isFieldMultiValued(field.getName())) {
                            if (consolidationTarget.containsElement(field)) continue;
                            consolidationTarget.addField(field);
                            continue;
                        }
                        consolidationTarget.removeAllFields(field.getName());
                        consolidationTarget.addField(field);
                    }
                    continue block14;
                }
                case "internal": {
                    break;
                }
            }
        }
        return consolidationTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SolrDoc createPartialUpdate(SolrDoc existing, SolrDoc future) {
        SolrDoc update2 = new SolrDoc();
        _log.debug("entering createPartialUpdate...");
        if (existing == null && future != null) {
            _log.debug("No existing solr record found");
            update2 = future.clone();
            update2.updateOrAddField("_version_", "-1");
        } else {
            boolean hasSysmetaSegment = false;
            for (String fieldName : this.solrSchema.getValidFields()) {
                SolrElementField clone;
                if (fieldName.equals("id") || fieldName.equals("_version_")) continue;
                if (this.solrSchema.isFieldMultiValued(fieldName)) {
                    SolrElementField clone2;
                    boolean removeExistingFirst;
                    String segment = this.solrSchema.getFieldSegment(fieldName);
                    _log.trace("segment is: " + segment + " for field: " + fieldName);
                    boolean bl = removeExistingFirst = segment.equals("sysmeta") || segment.equals("scimeta") || segment.equals("mn_service");
                    if (existing.hasField(fieldName)) {
                        if (future.hasField(fieldName)) {
                            SolrElementField clone3;
                            Iterator<SolrElementField> eValues = existing.getFields(fieldName);
                            List<SolrElementField> fValues = future.getFields(fieldName);
                            Collection both = CollectionUtils.intersection(eValues, fValues);
                            eValues.removeAll(both);
                            fValues.removeAll(both);
                            if (removeExistingFirst) {
                                Iterator<Object> iterator = eValues.iterator();
                                while (iterator.hasNext()) {
                                    SolrElementField e2 = (SolrElementField)iterator.next();
                                    clone3 = e2.clone();
                                    clone3.setModifier(SolrElementField.Modifier.REMOVE);
                                    update2.addField(clone3);
                                }
                            }
                            for (SolrElementField f : fValues) {
                                clone3 = f.clone();
                                clone3.setModifier(SolrElementField.Modifier.ADD);
                                update2.addField(clone3);
                            }
                            continue;
                        }
                        if (!removeExistingFirst) continue;
                        for (SolrElementField e3 : existing.getFields(fieldName)) {
                            clone2 = e3.clone();
                            clone2.setModifier(SolrElementField.Modifier.REMOVE);
                            update2.addField(clone2);
                        }
                        continue;
                    }
                    if (!future.hasField(fieldName)) continue;
                    for (SolrElementField f : future.getFields(fieldName)) {
                        clone2 = f.clone();
                        clone2.setModifier(SolrElementField.Modifier.ADD);
                        update2.addField(clone2);
                    }
                    continue;
                }
                if (existing.hasField(fieldName)) {
                    if (future.hasField(fieldName)) {
                        if (existing.getFirstFieldValue(fieldName).equals(future.getFirstFieldValue(fieldName))) continue;
                        clone = future.getField(fieldName);
                        clone.setModifier(SolrElementField.Modifier.SET);
                        update2.addField(clone);
                        continue;
                    }
                    clone = existing.getField(fieldName).clone();
                    clone.setModifier(SolrElementField.Modifier.REMOVE);
                    update2.addField(clone);
                    continue;
                }
                if (!future.hasField(fieldName)) continue;
                clone = future.getField(fieldName);
                clone.setModifier(SolrElementField.Modifier.SET);
                update2.addField(clone);
            }
            if (update2.getFieldList().size() > 0) {
                update2.addField(existing.getField("_version_"));
                update2.addField(existing.getField("id"));
            } else {
                return null;
            }
        }
        String version2 = update2.getFirstFieldValue("_version_");
        if (version2 == null) {
            _log.debug(".createPartialUpdate:  version = " + version2);
            List<SolrElementField> sysmeta = this.getSegment(update2, "sysmeta");
            _log.debug("sysmeta field count: " + (sysmeta != null ? Integer.valueOf(sysmeta.size()) : "null"));
            List<SolrElementField> scimeta = this.getSegment(update2, "scimeta");
            _log.debug("scimeta field count: " + (scimeta != null ? Integer.valueOf(scimeta.size()) : "null"));
            List<SolrElementField> service = this.getSegment(update2, "mn_service");
            _log.debug("mn_service field count: " + (service != null ? Integer.valueOf(service.size()) : "null"));
            if (this.getSegment(update2, "sysmeta").isEmpty() && this.getSegment(update2, "scimeta").isEmpty() && this.getSegment(update2, "mn_service").isEmpty()) {
                _log.debug(".createPartialUpdate / looks like a stub...");
                for (SolrElementField sef : update2.getFieldList()) {
                    if (_log.isDebugEnabled()) {
                        _log.debug("fieldName: " + sef.getName() + "; value: " + sef.getValue());
                    }
                    if (sef.getName().equals("id")) continue;
                    sef.setModifier(SolrElementField.Modifier.ADD);
                }
            } else {
                _log.debug(".createPartialUpdate / not a stub");
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug("createPartialUpdate complete...");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                update2.serialize(baos, "UTF-8");
                _log.debug(baos.toString());
            }
            catch (IOException e4) {
                _log.debug("!!!! Not able to serialize the update for debugging...: " + e4.getMessage());
            }
            finally {
                IOUtils.closeQuietly(baos);
            }
        }
        return update2;
    }

    public List<SolrElementField> getSegment(SolrDoc doc, String segmentName) {
        ArrayList<SolrElementField> fieldsToReturn = new ArrayList<SolrElementField>();
        _log.debug("entering getSegment(..) ...");
        if (doc != null && doc.getFieldList() != null) {
            _log.trace("getting all segment fields from schema for segment: '" + segmentName + "', schema: " + this.solrSchema);
            List<String> segFields = this.solrSchema.getAllSegmentFields(segmentName);
            _log.trace("got segment fields for " + segmentName);
            for (SolrElementField field : doc.getFieldList()) {
                if (segFields == null || !segFields.contains(field.getName())) continue;
                fieldsToReturn.add(field);
            }
        }
        _log.trace("...leaving getSegment()");
        return fieldsToReturn;
    }
}

