/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.resourcemap;

import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import org.dataone.cn.indexer.resourcemap.ForesiteResourceMap;
import org.dataone.cn.indexer.resourcemap.ResourceEntry;
import org.dataone.cn.indexer.resourcemap.ResourceMap;

public class ForesiteResourceEntry
implements ResourceEntry {
    private String identifier = null;
    private Set<String> resourceMaps = null;
    private ForesiteResourceMap parentMap = null;
    private Set<String> documents = null;
    private Set<String> documentedBy = null;

    public ForesiteResourceEntry(String identifier, ForesiteResourceMap parentMap) {
        this.setIdentifier(identifier);
        this.setResourceMaps(new HashSet<String>());
        this.setParentMap(parentMap);
        this.setDocuments(new HashSet<String>());
        this.setDocumentedBy(new HashSet<String>());
        this.getResourceMaps().add(parentMap.getIdentifier());
    }

    @Override
    public Set<String> getResourceMaps() {
        return this.resourceMaps;
    }

    @Override
    public void setResourceMaps(Set<String> resourceMaps) {
        this.resourceMaps = resourceMaps;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public Set<String> getDocuments() {
        return this.documents;
    }

    void setDocuments(Set<String> documents) {
        this.documents = documents;
    }

    public void addDocuments(String documents) {
        this.documents.add(documents);
    }

    @Override
    public Set<String> getDocumentedBy() {
        return this.documentedBy;
    }

    void setDocumentedBy(Set<String> documentedBy) {
        this.documentedBy = documentedBy;
    }

    public void addDocumentedBy(String documentedBy) {
        this.documentedBy.add(documentedBy);
    }

    @Override
    public String toString() {
        StringWriter sw = new StringWriter();
        sw.write("\tRESOURCE MAP ENTITY: ");
        sw.append(this.identifier);
        sw.write("\n");
        sw.write("\t\tDocuments: \n");
        for (String documentString : this.documents) {
            sw.write("\t\t\t");
            sw.append(documentString);
            sw.write("\n");
        }
        sw.write("\t\tisDocumentedByString: \n");
        for (String isDocumentedByString : this.documentedBy) {
            sw.write("\t\t\t");
            sw.append(isDocumentedByString);
            sw.write("\n");
        }
        sw.write("\t\tResource Maps: \n");
        for (String resourceMap : this.resourceMaps) {
            sw.write("\t\t\t");
            sw.append(resourceMap);
            sw.write("\n");
        }
        return sw.toString();
    }

    @Override
    public ResourceMap getParentMap() {
        return this.parentMap;
    }

    void setParentMap(ResourceMap parentMap) {
        this.parentMap = (ForesiteResourceMap)parentMap;
    }
}

