/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc;

import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Clob;
import org.hibernate.engine.jdbc.ClobProxy;
import org.hibernate.engine.jdbc.NClobImplementer;

public class NClobProxy
extends ClobProxy {
    public static final Class[] PROXY_INTERFACES = new Class[]{NClobProxy.determineNClobInterface(), NClobImplementer.class};

    private static Class determineNClobInterface() {
        try {
            return NClobProxy.getProxyClassLoader().loadClass("java.sql.NClob");
        }
        catch (ClassNotFoundException e2) {
            return Clob.class;
        }
    }

    protected NClobProxy(String string) {
        super(string);
    }

    protected NClobProxy(Reader reader, long length) {
        super(reader, length);
    }

    public static Clob generateProxy(String string) {
        return (Clob)Proxy.newProxyInstance(NClobProxy.getProxyClassLoader(), PROXY_INTERFACES, (InvocationHandler)new ClobProxy(string));
    }

    public static Clob generateProxy(Reader reader, long length) {
        return (Clob)Proxy.newProxyInstance(NClobProxy.getProxyClassLoader(), PROXY_INTERFACES, (InvocationHandler)new ClobProxy(reader, length));
    }

    protected static ClassLoader getProxyClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = NClobImplementer.class.getClassLoader();
        }
        return cl;
    }
}

