/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.proxy;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.cglib.core.CodeGenerationException;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.CallbackFilter;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.InvocationHandler;
import org.springframework.cglib.proxy.NoOp;

public class Proxy
implements Serializable {
    protected InvocationHandler h;
    private static final CallbackFilter BAD_OBJECT_METHOD_FILTER = new CallbackFilter(){

        public int accept(Method method) {
            String name;
            if (method.getDeclaringClass().getName().equals("java.lang.Object") && !(name = method.getName()).equals("hashCode") && !name.equals("equals") && !name.equals("toString")) {
                return 1;
            }
            return 0;
        }
    };

    protected Proxy(InvocationHandler h) {
        Enhancer.registerCallbacks(this.getClass(), new Callback[]{h, null});
        this.h = h;
    }

    public static InvocationHandler getInvocationHandler(Object proxy) {
        if (!(proxy instanceof ProxyImpl)) {
            throw new IllegalArgumentException("Object is not a proxy");
        }
        return ((Proxy)proxy).h;
    }

    public static Class getProxyClass(ClassLoader loader, Class[] interfaces) {
        Enhancer e2 = new Enhancer();
        e2.setSuperclass(ProxyImpl.class);
        e2.setInterfaces(interfaces);
        e2.setCallbackTypes(new Class[]{InvocationHandler.class, NoOp.class});
        e2.setCallbackFilter(BAD_OBJECT_METHOD_FILTER);
        e2.setUseFactory(false);
        return e2.createClass();
    }

    public static boolean isProxyClass(Class cl) {
        return cl.getSuperclass().equals(ProxyImpl.class);
    }

    public static Object newProxyInstance(ClassLoader loader, Class[] interfaces, InvocationHandler h) {
        try {
            Class clazz = Proxy.getProxyClass(loader, interfaces);
            return clazz.getConstructor(InvocationHandler.class).newInstance(h);
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new CodeGenerationException(e3);
        }
    }

    private static class ProxyImpl
    extends Proxy {
        protected ProxyImpl(InvocationHandler h) {
            super(h);
        }
    }
}

