/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.data.jpa.repository.support.LockMetadataProvider;
import org.springframework.data.jpa.repository.support.PersistenceProvider;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Repository
@Transactional(readOnly=true)
public class SimpleJpaRepository<T, ID extends Serializable>
implements JpaRepository<T, ID>,
JpaSpecificationExecutor<T> {
    private final JpaEntityInformation<T, ?> entityInformation;
    private final EntityManager em;
    private final PersistenceProvider provider;
    private LockMetadataProvider lockMetadataProvider;

    public SimpleJpaRepository(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        Assert.notNull(entityInformation);
        Assert.notNull(entityManager);
        this.entityInformation = entityInformation;
        this.em = entityManager;
        this.provider = PersistenceProvider.fromEntityManager(entityManager);
    }

    public SimpleJpaRepository(Class<T> domainClass, EntityManager em) {
        this(JpaEntityInformationSupport.getMetadata(domainClass, em), em);
    }

    public void setLockMetadataProvider(LockMetadataProvider lockMetadataProvider) {
        this.lockMetadataProvider = lockMetadataProvider;
    }

    private Class<T> getDomainClass() {
        return this.entityInformation.getJavaType();
    }

    private String getDeleteAllQueryString() {
        return QueryUtils.getQueryString("delete from %s x", this.entityInformation.getEntityName());
    }

    private String getCountQueryString() {
        String countQuery = String.format("select count(%s) from %s x", this.provider.getCountQueryPlaceholder(), "%s");
        return QueryUtils.getQueryString(countQuery, this.entityInformation.getEntityName());
    }

    @Override
    @Transactional
    public void delete(ID id) {
        Assert.notNull(id, "The given id must not be null!");
        T entity = this.findOne(id);
        if (entity == null) {
            throw new EmptyResultDataAccessException(String.format("No %s entity with id %s exists!", this.entityInformation.getJavaType(), id), 1);
        }
        this.delete(entity);
    }

    @Override
    @Transactional
    public void delete(T entity) {
        Assert.notNull(entity, "The entity must not be null!");
        this.em.remove(this.em.contains(entity) ? entity : this.em.merge(entity));
    }

    @Override
    @Transactional
    public void delete(Iterable<? extends T> entities) {
        Assert.notNull(entities, "The given Iterable of entities not be null!");
        for (T entity : entities) {
            this.delete(entity);
        }
    }

    @Override
    @Transactional
    public void deleteInBatch(Iterable<T> entities) {
        Assert.notNull(entities, "The given Iterable of entities not be null!");
        if (!entities.iterator().hasNext()) {
            return;
        }
        QueryUtils.applyAndBind(QueryUtils.getQueryString("delete from %s x", this.entityInformation.getEntityName()), entities, this.em).executeUpdate();
    }

    @Override
    @Transactional
    public void deleteAll() {
        for (Object element : this.findAll()) {
            this.delete((T)element);
        }
    }

    @Override
    @Transactional
    public void deleteAllInBatch() {
        this.em.createQuery(this.getDeleteAllQueryString()).executeUpdate();
    }

    @Override
    public T findOne(ID id) {
        Assert.notNull(id, "The given id must not be null!");
        LockModeType type = this.lockMetadataProvider == null ? null : this.lockMetadataProvider.getLockModeType();
        Class<T> domainType = this.getDomainClass();
        return type == null ? this.em.find(domainType, id) : this.em.find(domainType, id, type);
    }

    @Override
    public boolean exists(ID id) {
        Assert.notNull(id, "The given id must not be null!");
        if (this.entityInformation.getIdAttribute() != null) {
            String placeholder = this.provider.getCountQueryPlaceholder();
            String entityName = this.entityInformation.getEntityName();
            Iterable<String> idAttributeNames = this.entityInformation.getIdAttributeNames();
            String existsQuery = QueryUtils.getExistsQueryString(entityName, placeholder, idAttributeNames);
            TypedQuery<Long> query2 = this.em.createQuery(existsQuery, Long.class);
            if (this.entityInformation.hasCompositeId()) {
                for (String idAttributeName : idAttributeNames) {
                    query2.setParameter(idAttributeName, this.entityInformation.getCompositeIdAttributeValue((Serializable)id, idAttributeName));
                }
            } else {
                query2.setParameter(idAttributeNames.iterator().next(), id);
            }
            return query2.getSingleResult() == 1L;
        }
        return this.findOne(id) != null;
    }

    @Override
    public List<T> findAll() {
        return this.getQuery(null, (Sort)null).getResultList();
    }

    @Override
    public List<T> findAll(Iterable<ID> ids) {
        if (ids == null || !ids.iterator().hasNext()) {
            return Collections.emptyList();
        }
        ByIdsSpecification specification = new ByIdsSpecification();
        TypedQuery<Iterable<ID>> query2 = this.getQuery(specification, (Sort)null);
        return query2.setParameter(specification.parameter, ids).getResultList();
    }

    @Override
    public List<T> findAll(Sort sort) {
        return this.getQuery(null, sort).getResultList();
    }

    @Override
    public Page<T> findAll(Pageable pageable) {
        if (null == pageable) {
            return new PageImpl(this.findAll());
        }
        return this.findAll(null, pageable);
    }

    @Override
    public T findOne(Specification<T> spec) {
        try {
            return this.getQuery(spec, (Sort)null).getSingleResult();
        }
        catch (NoResultException e2) {
            return null;
        }
    }

    @Override
    public List<T> findAll(Specification<T> spec) {
        return this.getQuery(spec, (Sort)null).getResultList();
    }

    @Override
    public Page<T> findAll(Specification<T> spec, Pageable pageable) {
        TypedQuery<T> query2 = this.getQuery(spec, pageable);
        return pageable == null ? new PageImpl<T>(query2.getResultList()) : this.readPage(query2, pageable, spec);
    }

    @Override
    public List<T> findAll(Specification<T> spec, Sort sort) {
        return this.getQuery(spec, sort).getResultList();
    }

    @Override
    public long count() {
        return this.em.createQuery(this.getCountQueryString(), Long.class).getSingleResult();
    }

    @Override
    public long count(Specification<T> spec) {
        return this.getCountQuery(spec).getSingleResult();
    }

    @Override
    @Transactional
    public <S extends T> S save(S entity) {
        if (this.entityInformation.isNew(entity)) {
            this.em.persist(entity);
            return entity;
        }
        return this.em.merge(entity);
    }

    @Override
    @Transactional
    public T saveAndFlush(T entity) {
        T result = this.save(entity);
        this.flush();
        return result;
    }

    @Override
    @Transactional
    public <S extends T> List<S> save(Iterable<S> entities) {
        ArrayList<S> result = new ArrayList<S>();
        if (entities == null) {
            return result;
        }
        for (S entity : entities) {
            result.add(this.save(entity));
        }
        return result;
    }

    @Override
    @Transactional
    public void flush() {
        this.em.flush();
    }

    private Page<T> readPage(TypedQuery<T> query2, Pageable pageable, Specification<T> spec) {
        query2.setFirstResult(pageable.getOffset());
        query2.setMaxResults(pageable.getPageSize());
        Long total = QueryUtils.executeCountQuery(this.getCountQuery(spec));
        List content = total > (long)pageable.getOffset() ? query2.getResultList() : Collections.emptyList();
        return new PageImpl(content, pageable, total);
    }

    private TypedQuery<T> getQuery(Specification<T> spec, Pageable pageable) {
        Sort sort = pageable == null ? null : pageable.getSort();
        return this.getQuery(spec, sort);
    }

    private TypedQuery<T> getQuery(Specification<T> spec, Sort sort) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery<T> query2 = builder.createQuery(this.getDomainClass());
        Root<T> root2 = this.applySpecificationToCriteria(spec, query2);
        query2.select(root2);
        if (sort != null) {
            query2.orderBy(QueryUtils.toOrders(sort, root2, builder));
        }
        return this.applyLockMode(this.em.createQuery(query2));
    }

    private TypedQuery<Long> getCountQuery(Specification<T> spec) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery<Long> query2 = builder.createQuery(Long.class);
        Root<T> root2 = this.applySpecificationToCriteria(spec, query2);
        if (query2.isDistinct()) {
            query2.select(builder.countDistinct(root2));
        } else {
            query2.select(builder.count(root2));
        }
        return this.em.createQuery(query2);
    }

    private <S> Root<T> applySpecificationToCriteria(Specification<T> spec, CriteriaQuery<S> query2) {
        Assert.notNull(query2);
        Root<T> root2 = query2.from(this.getDomainClass());
        if (spec == null) {
            return root2;
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        Predicate predicate = spec.toPredicate(root2, query2, builder);
        if (predicate != null) {
            query2.where((Expression<Boolean>)predicate);
        }
        return root2;
    }

    private TypedQuery<T> applyLockMode(TypedQuery<T> query2) {
        LockModeType type = this.lockMetadataProvider == null ? null : this.lockMetadataProvider.getLockModeType();
        return type == null ? query2 : query2.setLockMode(type);
    }

    private final class ByIdsSpecification
    implements Specification<T> {
        ParameterExpression<Iterable> parameter;

        private ByIdsSpecification() {
        }

        @Override
        public Predicate toPredicate(Root<T> root2, CriteriaQuery<?> query2, CriteriaBuilder cb) {
            Path<?> path = root2.get(SimpleJpaRepository.this.entityInformation.getIdAttribute());
            this.parameter = cb.parameter(Iterable.class);
            return path.in(new Expression[]{this.parameter});
        }
    }
}

