/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.objenesis.instantiator.android;

import java.io.ObjectStreamClass;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.objenesis.ObjenesisException;
import org.springframework.objenesis.instantiator.ObjectInstantiator;
import org.springframework.objenesis.instantiator.annotations.Instantiator;
import org.springframework.objenesis.instantiator.annotations.Typology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Instantiator(value=Typology.SERIALIZATION)
public class AndroidSerializationInstantiator<T>
implements ObjectInstantiator<T> {
    private final Class<T> type;
    private final ObjectStreamClass objectStreamClass;
    private final Method newInstanceMethod;

    public AndroidSerializationInstantiator(Class<T> type) {
        this.type = type;
        this.newInstanceMethod = AndroidSerializationInstantiator.getNewInstanceMethod();
        Method m = null;
        try {
            m = ObjectStreamClass.class.getMethod("lookupAny", Class.class);
        }
        catch (NoSuchMethodException e2) {
            throw new ObjenesisException(e2);
        }
        try {
            this.objectStreamClass = (ObjectStreamClass)m.invoke(null, type);
        }
        catch (IllegalAccessException e3) {
            throw new ObjenesisException(e3);
        }
        catch (InvocationTargetException e4) {
            throw new ObjenesisException(e4);
        }
    }

    @Override
    public T newInstance() {
        try {
            return this.type.cast(this.newInstanceMethod.invoke((Object)this.objectStreamClass, this.type));
        }
        catch (IllegalAccessException e2) {
            throw new ObjenesisException(e2);
        }
        catch (IllegalArgumentException e3) {
            throw new ObjenesisException(e3);
        }
        catch (InvocationTargetException e4) {
            throw new ObjenesisException(e4);
        }
    }

    private static Method getNewInstanceMethod() {
        try {
            Method newInstanceMethod = ObjectStreamClass.class.getDeclaredMethod("newInstance", Class.class);
            newInstanceMethod.setAccessible(true);
            return newInstanceMethod;
        }
        catch (RuntimeException e2) {
            throw new ObjenesisException(e2);
        }
        catch (NoSuchMethodException e3) {
            throw new ObjenesisException(e3);
        }
    }
}

