/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.objenesis.instantiator.sun;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.objenesis.ObjenesisException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SunReflectionFactoryHelper {
    SunReflectionFactoryHelper() {
    }

    public static <T> Constructor<T> newConstructorForSerialization(Class<T> type, Constructor<?> constructor) {
        Class<?> reflectionFactoryClass = SunReflectionFactoryHelper.getReflectionFactoryClass();
        Object reflectionFactory = SunReflectionFactoryHelper.createReflectionFactory(reflectionFactoryClass);
        Method newConstructorForSerializationMethod = SunReflectionFactoryHelper.getNewConstructorForSerializationMethod(reflectionFactoryClass);
        try {
            return (Constructor)newConstructorForSerializationMethod.invoke(reflectionFactory, type, constructor);
        }
        catch (IllegalArgumentException e2) {
            throw new ObjenesisException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new ObjenesisException(e3);
        }
        catch (InvocationTargetException e4) {
            throw new ObjenesisException(e4);
        }
    }

    private static Class<?> getReflectionFactoryClass() {
        try {
            return Class.forName("sun.reflect.ReflectionFactory");
        }
        catch (ClassNotFoundException e2) {
            throw new ObjenesisException(e2);
        }
    }

    private static Object createReflectionFactory(Class<?> reflectionFactoryClass) {
        try {
            Method method = reflectionFactoryClass.getDeclaredMethod("getReflectionFactory", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e2) {
            throw new ObjenesisException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new ObjenesisException(e3);
        }
        catch (IllegalArgumentException e4) {
            throw new ObjenesisException(e4);
        }
        catch (InvocationTargetException e5) {
            throw new ObjenesisException(e5);
        }
    }

    private static Method getNewConstructorForSerializationMethod(Class<?> reflectionFactoryClass) {
        try {
            return reflectionFactoryClass.getDeclaredMethod("newConstructorForSerialization", Class.class, Constructor.class);
        }
        catch (NoSuchMethodException e2) {
            throw new ObjenesisException(e2);
        }
    }
}

