/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.jdbc;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.jdbc.datasource.init.ScriptUtils;
import org.springframework.util.StringUtils;

public class JdbcTestUtils {
    private static final Log logger = LogFactory.getLog(JdbcTestUtils.class);

    public static int countRowsInTable(JdbcTemplate jdbcTemplate, String tableName) {
        return jdbcTemplate.queryForObject("SELECT COUNT(0) FROM " + tableName, Integer.class);
    }

    public static int countRowsInTableWhere(JdbcTemplate jdbcTemplate, String tableName, String whereClause) {
        String sql = "SELECT COUNT(0) FROM " + tableName;
        if (StringUtils.hasText(whereClause)) {
            sql = sql + " WHERE " + whereClause;
        }
        return jdbcTemplate.queryForObject(sql, Integer.class);
    }

    public static int deleteFromTables(JdbcTemplate jdbcTemplate, String ... tableNames) {
        int totalRowCount = 0;
        for (String tableName : tableNames) {
            int rowCount = jdbcTemplate.update("DELETE FROM " + tableName);
            totalRowCount += rowCount;
            if (!logger.isInfoEnabled()) continue;
            logger.info("Deleted " + rowCount + " rows from table " + tableName);
        }
        return totalRowCount;
    }

    public static int deleteFromTableWhere(JdbcTemplate jdbcTemplate, String tableName, String whereClause, Object ... args) {
        int rowCount;
        String sql = "DELETE FROM " + tableName;
        if (StringUtils.hasText(whereClause)) {
            sql = sql + " WHERE " + whereClause;
        }
        int n = rowCount = args != null && args.length > 0 ? jdbcTemplate.update(sql, args) : jdbcTemplate.update(sql);
        if (logger.isInfoEnabled()) {
            logger.info("Deleted " + rowCount + " rows from table " + tableName);
        }
        return rowCount;
    }

    public static void dropTables(JdbcTemplate jdbcTemplate, String ... tableNames) {
        for (String tableName : tableNames) {
            jdbcTemplate.execute("DROP TABLE " + tableName);
            if (!logger.isInfoEnabled()) continue;
            logger.info("Dropped table " + tableName);
        }
    }

    @Deprecated
    public static void executeSqlScript(JdbcTemplate jdbcTemplate, ResourceLoader resourceLoader, String sqlResourcePath, boolean continueOnError) throws DataAccessException {
        Resource resource = resourceLoader.getResource(sqlResourcePath);
        JdbcTestUtils.executeSqlScript(jdbcTemplate, resource, continueOnError);
    }

    @Deprecated
    public static void executeSqlScript(JdbcTemplate jdbcTemplate, Resource resource, boolean continueOnError) throws DataAccessException {
        JdbcTestUtils.executeSqlScript(jdbcTemplate, new EncodedResource(resource), continueOnError);
    }

    @Deprecated
    public static void executeSqlScript(JdbcTemplate jdbcTemplate, EncodedResource resource, boolean continueOnError) throws DataAccessException {
        new ResourceDatabasePopulator(continueOnError, false, resource.getEncoding(), resource.getResource()).execute(jdbcTemplate.getDataSource());
    }

    @Deprecated
    public static String readScript(LineNumberReader lineNumberReader) throws IOException {
        return JdbcTestUtils.readScript(lineNumberReader, "--");
    }

    @Deprecated
    public static String readScript(LineNumberReader lineNumberReader, String commentPrefix) throws IOException {
        return ScriptUtils.readScript(lineNumberReader, commentPrefix, ";");
    }

    @Deprecated
    public static boolean containsSqlScriptDelimiters(String script, char delim) {
        return ScriptUtils.containsSqlScriptDelimiters(script, String.valueOf(delim));
    }

    @Deprecated
    public static void splitSqlScript(String script, char delim, List<String> statements) {
        ScriptUtils.splitSqlScript(script, delim, statements);
    }
}

