/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.partition;

import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.PartitionManager;
import com.hazelcast.impl.concurrentmap.CostAwareRecordList;
import com.hazelcast.impl.partition.MigratingPartition;
import com.hazelcast.impl.partition.MigrationTask;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationRequestTask
extends MigratingPartition
implements Callable<Boolean>,
DataSerializable,
HazelcastInstanceAware {
    private boolean migration;
    private boolean diffOnly;
    private int selfCopyReplicaIndex = -1;
    private transient HazelcastInstance hazelcast;

    public MigrationRequestTask() {
    }

    public MigrationRequestTask(int partitionId, Address from, Address to, int replicaIndex, boolean migration) {
        this(partitionId, from, to, replicaIndex, migration, false);
    }

    public MigrationRequestTask(int partitionId, Address from, Address to, int replicaIndex, boolean migration, boolean diffOnly) {
        super(partitionId, replicaIndex, from, to);
        this.migration = migration;
        this.diffOnly = diffOnly;
    }

    public boolean isMigration() {
        return this.migration;
    }

    public int getSelfCopyReplicaIndex() {
        return this.selfCopyReplicaIndex;
    }

    public void setSelfCopyReplicaIndex(int selfCopyReplicaIndex) {
        this.selfCopyReplicaIndex = selfCopyReplicaIndex;
    }

    public void setFromAddress(Address from) {
        this.from = from;
    }

    @Override
    public Boolean call() throws Exception {
        if (this.to.equals(this.from)) {
            this.getLogger().log(Level.FINEST, "To and from addresses are same! => " + this.toString());
            return Boolean.TRUE;
        }
        if (this.from == null) {
            this.getLogger().log(Level.FINEST, "From address is null => " + this.toString());
        }
        Node node = ((FactoryImpl)this.hazelcast).node;
        PartitionManager pm = node.concurrentMapManager.getPartitionManager();
        try {
            MemberImpl target = pm.getMember(this.to);
            if (target == null) {
                this.getLogger().log(Level.WARNING, "Target member of task could not be found! => " + this.toString());
                return Boolean.FALSE;
            }
            CostAwareRecordList costAwareRecordList = pm.getActivePartitionRecords(this.partitionId, this.replicaIndex, this.to, this.diffOnly);
            DistributedTask<Boolean> task = new DistributedTask<Boolean>(new MigrationTask(this.partitionId, costAwareRecordList, this.replicaIndex, this.from), target);
            Future<?> future = node.factory.getExecutorService("hz.migration").submit(task);
            long timeout = node.groupProperties.PARTITION_MIGRATION_TIMEOUT.getLong();
            return (Boolean)future.get(timeout, TimeUnit.SECONDS);
        }
        catch (Throwable e2) {
            Level level = Level.WARNING;
            if (e2 instanceof ExecutionException) {
                e2 = e2.getCause();
            }
            if (e2 instanceof MemberLeftException || e2 instanceof IllegalStateException) {
                level = Level.FINEST;
            }
            this.getLogger().log(level, e2.getMessage(), e2);
            return Boolean.FALSE;
        }
    }

    private ILogger getLogger() {
        return ((FactoryImpl)this.hazelcast).node.getLogger(MigrationRequestTask.class.getName());
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        super.writeData(out);
        out.writeBoolean(this.migration);
        out.writeBoolean(this.diffOnly);
        out.writeInt(this.selfCopyReplicaIndex);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        super.readData(in);
        this.migration = in.readBoolean();
        this.diffOnly = in.readBoolean();
        this.selfCopyReplicaIndex = in.readInt();
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcast = hazelcastInstance;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MigrationRequestTask");
        sb.append("{partitionId=").append(this.partitionId);
        sb.append(", from=").append(this.from);
        sb.append(", to=").append(this.to);
        sb.append(", replicaIndex=").append(this.replicaIndex);
        sb.append(", migration=").append(this.migration);
        sb.append(", diffOnly=").append(this.diffOnly);
        sb.append(", selfCopyReplicaIndex=").append(this.selfCopyReplicaIndex);
        sb.append('}');
        return sb.toString();
    }
}

