/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.assemblers.LocationMapperAssembler;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.LocationMapper;
import com.hp.hpl.jena.vocabulary.LocationMappingVocab;
import java.util.Iterator;
import java.util.Set;

public class TestLocationMapperAssembler
extends AssemblerTestBase {
    public TestLocationMapperAssembler(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        return LocationMapperAssembler.class;
    }

    public void testLocationMapperAssemblerType() {
        this.testDemandsMinimalType(new LocationMapperAssembler(), JA.LocationMapper);
    }

    public void testLocationMapperVocabulary() {
        this.assertSubclassOf(JA.LocationMapper, JA.Object);
        this.assertDomain(JA.LocationMapper, LocationMappingVocab.mapping);
    }

    public void testCreatesLocationMapper() {
        Resource root2 = this.resourceInModel("r rdf:type ja:LocationMapper");
        LocationMapperAssembler a = new LocationMapperAssembler();
        Object x = a.open(root2);
        TestLocationMapperAssembler.assertInstanceOf(LocationMapper.class, x);
    }

    public void testCreatesWithCorrectContent() {
        Resource root2 = this.resourceInModel("r rdf:type ja:LocationMapper; r lm:mapping _m; _m lm:name 'alpha'; _m lm:altName 'beta'");
        LocationMapperAssembler a = new LocationMapperAssembler();
        Object x = a.open(root2);
        TestLocationMapperAssembler.assertInstanceOf(LocationMapper.class, x);
        this.assertEqualMaps(new LocationMapper(root2.getModel()), (LocationMapper)x);
    }

    private void assertEqualMaps(LocationMapper expected, LocationMapper got) {
        String key;
        Set eAltEntryKeys = IteratorCollection.iteratorToSet(expected.listAltEntries());
        Set gAltEntryKeys = IteratorCollection.iteratorToSet(got.listAltEntries());
        Set eAltPrefixKeys = IteratorCollection.iteratorToSet(expected.listAltPrefixes());
        Set gAltPrefixKeys = IteratorCollection.iteratorToSet(got.listAltPrefixes());
        TestLocationMapperAssembler.assertEquals((String)"altEntry keys dhould be equal", (Object)eAltEntryKeys, (Object)gAltEntryKeys);
        TestLocationMapperAssembler.assertEquals((String)"prefixEntry keys should be equal", (Object)eAltPrefixKeys, (Object)gAltPrefixKeys);
        Iterator altKeys = eAltEntryKeys.iterator();
        while (altKeys.hasNext()) {
            key = (String)altKeys.next();
            TestLocationMapperAssembler.assertEquals((String)"alt entrys should be equal", (String)expected.getAltEntry(key), (String)got.getAltEntry(key));
        }
        Iterator preKeys = eAltPrefixKeys.iterator();
        while (preKeys.hasNext()) {
            key = (String)preKeys.next();
            TestLocationMapperAssembler.assertEquals((String)"prefix entiries should be equal", (String)expected.getAltPrefix(key), (String)got.getAltPrefix(key));
        }
    }
}

