/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.TreeQueryPlan;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import java.util.Set;

public class SimpleTreeQueryPlan
implements TreeQueryPlan {
    private Graph pattern;
    private Graph target;

    public SimpleTreeQueryPlan(Graph target, Graph pattern) {
        this.target = target;
        this.pattern = pattern;
    }

    public Graph executeTree() {
        Graph result = Factory.createGraphMem();
        Set roots = SimpleTreeQueryPlan.getRoots(this.pattern);
        Iterator it = roots.iterator();
        while (it.hasNext()) {
            this.handleRoot(result, (Node)it.next(), CollectionFactory.createHashedSet());
        }
        return result;
    }

    private Iterator findFromTriple(Graph g, Triple t) {
        return g.find(this.asPattern(t.getSubject()), this.asPattern(t.getPredicate()), this.asPattern(t.getObject()));
    }

    private Node asPattern(Node x) {
        return x.isBlank() ? null : x;
    }

    private void handleRoot(Graph result, Node root2, Set pending) {
        ExtendedIterator it = this.pattern.find(root2, null, null);
        if (!it.hasNext()) {
            this.absorb(result, pending);
            return;
        }
        while (it.hasNext()) {
            Triple base = (Triple)it.next();
            Iterator that = this.findFromTriple(this.target, base);
            while (that.hasNext()) {
                Triple x = (Triple)that.next();
                pending.add(x);
                this.handleRoot(result, base.getObject(), pending);
            }
        }
    }

    private void absorb(Graph result, Set triples) {
        Iterator it = triples.iterator();
        while (it.hasNext()) {
            result.add((Triple)it.next());
        }
        triples.clear();
    }

    public static Set getRoots(Graph pattern) {
        Set roots = CollectionFactory.createHashedSet();
        ExtendedIterator sub = GraphUtil.findAll(pattern);
        while (sub.hasNext()) {
            roots.add(((Triple)sub.next()).getSubject());
        }
        ExtendedIterator obj = GraphUtil.findAll(pattern);
        while (obj.hasNext()) {
            roots.remove(((Triple)obj.next()).getObject());
        }
        return roots;
    }
}

