/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphExtract;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TripleBoundary;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import junit.framework.TestSuite;

public class TestGraphExtract
extends GraphTestBase {
    public TestGraphExtract(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestGraphExtract.class);
    }

    public void testExtractNothing() {
        this.testExtract("", "x", "");
        this.testExtract("", "x", "a R b");
        this.testExtract("", "x", "a R x");
        this.testExtract("", "x", "a x y");
    }

    public void testExtractOneLevel() {
        this.testExtract("a R b", "a", "a R b");
        this.testExtract("a R b; a R c", "a", "a R b; a R c");
        this.testExtract("a R b; a S d", "a", "a R b; a S d");
    }

    public void testNoJunk() {
        this.testExtract("a R b", "a", "a R b; x R y");
    }

    public void testExtractTwoLevels() {
        this.testExtract("a R b; b S c", "a", "a R b; b S c");
        this.testExtract("a R b; b S c", "a", "a R b; b S c; x P y");
        this.testExtract("a R b; b S c; b T d", "a", "a R b; b S c; b T d");
        this.testExtract("a R b; b S c; a T d", "a", "a R b; a T d; b S c");
    }

    public void testExtractSeveralLevels() {
        this.testExtract("a R b; b S c; c T d; d U e", "a", "a R b; b S c; c T d; d U e");
    }

    public void testExtractNoLoop() {
        this.testExtract("a R a", "a", "a R a");
        this.testExtract("a R b; b R a", "a", "a R b; b R a; z P a");
        this.testExtract("a R b; b S c; c T a", "a", "a R b; b S c; c T a; junk P junk");
    }

    public void testTripleFilter() {
        TestGraphExtract.assertTrue((boolean)TripleBoundary.stopAtAnonObject.stopAt(TestGraphExtract.triple("a R _b")));
        TestGraphExtract.assertFalse((boolean)TripleBoundary.stopAtAnonObject.stopAt(TestGraphExtract.triple("a R b")));
        TestGraphExtract.assertFalse((boolean)TripleBoundary.stopAtAnonObject.stopAt(TestGraphExtract.triple("a _R b")));
        TestGraphExtract.assertFalse((boolean)TripleBoundary.stopAtAnonObject.stopAt(TestGraphExtract.triple("_a R b")));
    }

    public void testExtractBoundary() {
        this.testExtract("a R b; b S _c", "a", "a R b; b S _c; _c T d", TripleBoundary.stopAtAnonObject);
    }

    public void testPartialUpdate() {
        Graph source = TestGraphExtract.graphWith("a R b; b S e");
        Graph dest = TestGraphExtract.graphWith("b R d");
        GraphExtract e2 = new GraphExtract(TripleBoundary.stopNowhere);
        e2.extractInto(dest, TestGraphExtract.node("a"), source);
        TestGraphExtract.assertIsomorphic(TestGraphExtract.graphWith("a R b; b S e; b R d"), dest);
    }

    public void testExtract(String wanted, String node, String source) {
        this.testExtract(wanted, node, source, TripleBoundary.stopNowhere);
    }

    private void testExtract(String wanted, String node, String source, TripleBoundary b) {
        TestGraphExtract.assertIsomorphic(TestGraphExtract.graphWith(wanted), this.extract(TestGraphExtract.node(node), b, TestGraphExtract.graphWith(source)));
    }

    public Graph extract(Node node, TripleBoundary b, Graph graph) {
        return new GraphExtract(b).extract(node, graph);
    }
}

