/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.ProfileRegistry;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestOntReasoning
extends TestCase {
    public static final String BASE = "http://jena.hpl.hp.com/testing/ontology";
    public static final String NS = "http://jena.hpl.hp.com/testing/ontology#";

    public TestOntReasoning(String name) {
        super(name);
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void tearDown() {
    }

    public void testSubClassDirectTransInf1a() {
        OntModel m = ModelFactory.createOntologyModel(ProfileRegistry.OWL_LITE_LANG);
        OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
        OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
        OntClass C2 = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
        OntClass D = m.createClass("http://jena.hpl.hp.com/testing/ontology#D");
        A.addSubClass(B);
        A.addSubClass(C2);
        C2.addSubClass(D);
        this.iteratorTest(A.listSubClasses(), new Object[]{B, C2, D});
        this.iteratorTest(A.listSubClasses(true), new Object[]{B, C2});
    }

    public void testSubClassDirectTransInf1b() {
        OntModel m = ModelFactory.createOntologyModel(ProfileRegistry.OWL_LITE_LANG);
        OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
        OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
        OntClass C2 = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
        OntClass D = m.createClass("http://jena.hpl.hp.com/testing/ontology#D");
        A.addSubClass(B);
        A.addSubClass(C2);
        C2.addSubClass(D);
        A.addSubClass(D);
        this.iteratorTest(A.listSubClasses(), new Object[]{B, C2, D});
        this.iteratorTest(A.listSubClasses(true), new Object[]{B, C2});
    }

    public void testSubClassDirectTransInf2a() {
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_LITE_MEM);
        spec.setReasonerFactory(null);
        OntModel m = ModelFactory.createOntologyModel(spec, null);
        OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
        OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
        OntClass C2 = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
        OntClass D = m.createClass("http://jena.hpl.hp.com/testing/ontology#D");
        A.addSubClass(B);
        A.addSubClass(C2);
        C2.addSubClass(D);
        this.iteratorTest(A.listSubClasses(), new Object[]{B, C2});
        this.iteratorTest(A.listSubClasses(true), new Object[]{B, C2});
    }

    public void testSubClassDirectTransInf2b() {
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_LITE_MEM);
        spec.setReasonerFactory(null);
        OntModel m = ModelFactory.createOntologyModel(spec, null);
        OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
        OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
        OntClass C2 = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
        OntClass D = m.createClass("http://jena.hpl.hp.com/testing/ontology#D");
        A.addSubClass(B);
        A.addSubClass(C2);
        C2.addSubClass(D);
        A.addSubClass(D);
        this.iteratorTest(A.listSubClasses(), new Object[]{B, C2, D});
        this.iteratorTest(A.listSubClasses(true), new Object[]{B, C2});
    }

    public void testSubPropertyDirectTransInf1a() {
        OntModel m = ModelFactory.createOntologyModel(ProfileRegistry.OWL_LITE_LANG);
        ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
        ObjectProperty q = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
        ObjectProperty r = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
        ObjectProperty s = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#s");
        p.addSubProperty(q);
        p.addSubProperty(r);
        r.addSubProperty(s);
        this.iteratorTest(p.listSubProperties(), new Object[]{p, q, r, s});
        this.iteratorTest(p.listSubProperties(true), new Object[]{q, r});
    }

    public void testSubPropertyDirectTransInf1b() {
        OntModel m = ModelFactory.createOntologyModel(ProfileRegistry.OWL_LITE_LANG);
        ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
        ObjectProperty q = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
        ObjectProperty r = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
        ObjectProperty s = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#s");
        p.addSubProperty(q);
        p.addSubProperty(r);
        r.addSubProperty(s);
        p.addSubProperty(s);
        this.iteratorTest(p.listSubProperties(), new Object[]{p, q, r, s});
        this.iteratorTest(p.listSubProperties(true), new Object[]{q, r});
    }

    public void testSubPropertyDirectTransInf2a() {
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_LITE_MEM);
        spec.setReasonerFactory(null);
        OntModel m = ModelFactory.createOntologyModel(spec, null);
        ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
        ObjectProperty q = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
        ObjectProperty r = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
        ObjectProperty s = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#s");
        p.addSubProperty(q);
        p.addSubProperty(r);
        r.addSubProperty(s);
        this.iteratorTest(p.listSubProperties(), new Object[]{q, r});
        this.iteratorTest(p.listSubProperties(true), new Object[]{q, r});
    }

    public void testSubPropertyDirectTransInf2b() {
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_LITE_MEM);
        spec.setReasonerFactory(null);
        OntModel m = ModelFactory.createOntologyModel(spec, null);
        ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
        ObjectProperty q = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
        ObjectProperty r = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
        ObjectProperty s = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#s");
        p.addSubProperty(q);
        p.addSubProperty(r);
        r.addSubProperty(s);
        p.addSubProperty(s);
        this.iteratorTest(p.listSubProperties(), new Object[]{q, r, s});
        this.iteratorTest(p.listSubProperties(true), new Object[]{q, r});
    }

    public void testListDefinedProperties() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RULE_INF, null);
        OntClass organism = m.createClass("http://jena.hpl.hp.com/testing/ontology#Organism");
        OntClass vertebrate = m.createClass("http://jena.hpl.hp.com/testing/ontology#Vertebrate");
        OntClass mammal = m.createClass("http://jena.hpl.hp.com/testing/ontology#Mammal");
        OntClass dog = m.createClass("http://jena.hpl.hp.com/testing/ontology#Dog");
        organism.addSubClass(vertebrate);
        vertebrate.addSubClass(mammal);
        mammal.addSubClass(dog);
        OntClass covering = m.createClass("http://jena.hpl.hp.com/testing/ontology#Covering");
        Individual hair = m.createIndividual("http://jena.hpl.hp.com/testing/ontology#hair", covering);
        DatatypeProperty limbsCount = m.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#limbsCount");
        DatatypeProperty hasCovering = m.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#hasCovering");
        DatatypeProperty numYoung = m.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#numYoung");
        limbsCount.addDomain(vertebrate);
        numYoung.addDomain(mammal);
        Restriction r = m.createRestriction(hasCovering);
        r.convertToHasValueRestriction(hair);
        mammal.addSuperClass(r);
        this.iteratorTest(organism.listDeclaredProperties(), new Object[]{hasCovering});
        this.iteratorTest(vertebrate.listDeclaredProperties(), new Object[]{limbsCount, hasCovering});
        this.iteratorTest(mammal.listDeclaredProperties(), new Object[]{limbsCount, hasCovering, numYoung});
        this.iteratorTest(dog.listDeclaredProperties(), new Object[]{limbsCount, hasCovering, numYoung});
        this.iteratorTest(r.listDeclaredProperties(), new Object[]{hasCovering});
        this.iteratorTest(organism.listDeclaredProperties(true), new Object[]{hasCovering});
        this.iteratorTest(vertebrate.listDeclaredProperties(true), new Object[]{limbsCount});
        this.iteratorTest(mammal.listDeclaredProperties(true), new Object[]{numYoung});
        this.iteratorTest(dog.listDeclaredProperties(true), new Object[0]);
        this.iteratorTest(r.listDeclaredProperties(true), new Object[]{hasCovering});
        this.iteratorTest(organism.listDeclaredProperties(false), new Object[]{hasCovering});
        this.iteratorTest(vertebrate.listDeclaredProperties(false), new Object[]{hasCovering, limbsCount});
        this.iteratorTest(mammal.listDeclaredProperties(false), new Object[]{hasCovering, numYoung, limbsCount});
        this.iteratorTest(dog.listDeclaredProperties(false), new Object[]{hasCovering, numYoung, limbsCount});
        this.iteratorTest(r.listDeclaredProperties(false), new Object[]{hasCovering});
    }

    protected void iteratorTest(Iterator i, Object[] expected) {
        Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
        ArrayList<Object> expList = new ArrayList<Object>();
        for (int j = 0; j < expected.length; ++j) {
            expList.add(expected[j]);
        }
        while (i.hasNext()) {
            Object next = i.next();
            if (!expList.contains(next)) {
                logger.debug(this.getName() + " - Unexpected iterator result: " + next);
            }
            TestOntReasoning.assertTrue((String)("Value " + next + " was not expected as a result from this iterator "), (boolean)expList.contains(next));
            TestOntReasoning.assertTrue((String)("Value " + next + " was not removed from the list "), (boolean)expList.remove(next));
        }
        if (expList.size() != 0) {
            logger.debug(this.getName() + " Expected iterator results not found");
            Iterator j = expList.iterator();
            while (j.hasNext()) {
                logger.debug(this.getName() + " - missing: " + j.next());
            }
        }
        TestOntReasoning.assertEquals((String)"There were expected elements from the iterator that were not found", (int)0, (int)expList.size());
    }
}

