/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.impl.ModelReifier;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.PrefixMapping;
import junit.framework.TestSuite;

public class TestHiddenStatements
extends ModelTestBase {
    public TestHiddenStatements(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestHiddenStatements.class);
    }

    public void assertSameMapping(PrefixMapping L, PrefixMapping R) {
        if (!this.sameMapping(L, R)) {
            TestHiddenStatements.fail((String)("wanted " + L + " but got " + R));
        }
    }

    public boolean sameMapping(PrefixMapping L, PrefixMapping R) {
        return ((Object)L.getNsPrefixMap()).equals(R.getNsPrefixMap());
    }

    public void testPrefixCopied() {
        Model m = ModelFactory.createDefaultModel();
        m.setNsPrefixes(PrefixMapping.Standard);
        this.assertSameMapping(PrefixMapping.Standard, ModelReifier.withHiddenStatements(m));
    }
}

