/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.ItemVisitor;
import java.util.Iterator;

public class ItemWalker {
    static void walk(ItemVisitor visitor, Item item) {
        item.visit(new Worker(visitor));
    }

    static class Worker
    implements ItemVisitor {
        private ItemVisitor visitor;

        Worker(ItemVisitor visitor) {
            this.visitor = visitor;
        }

        public void visit(Item item, ItemList list) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Item subItem = (Item)iter.next();
                subItem.visit(this);
            }
            this.visitor.visit(item, list);
        }

        public void visit(Item item, Node node) {
            this.visitor.visit(item, node);
        }

        public void visit(Item item, String symbol) {
            this.visitor.visit(item, symbol);
        }

        public void visitNil() {
            this.visitor.visitNil();
        }
    }
}

