/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.builders;

import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.TableFactory;
import com.hp.hpl.jena.sparql.algebra.table.TableUnit;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.builders.BuilderBase;
import com.hp.hpl.jena.sparql.sse.builders.BuilderBinding;

public class BuilderTable {
    public static Table build(Item item) {
        String symbol;
        BuilderBase.checkTagged(item, "table", "Not a (table ...)");
        ItemList list = item.getList();
        int start = 1;
        if (list.size() == 1) {
            return TableFactory.createEmpty();
        }
        if (list.size() == 2 && list.get(1).isSymbol() && (symbol = list.get(1).getSymbol()).equals("unit")) {
            return new TableUnit();
        }
        Table table = TableFactory.create();
        int count = 0;
        Binding lastBinding = null;
        for (int i = start; i < list.size(); ++i) {
            Item itemRow = list.get(i);
            Binding b = BuilderBinding.build(itemRow);
            table.addBinding(b);
            lastBinding = b;
            ++count;
        }
        if (table.size() == 1 && lastBinding.isEmpty()) {
            return TableFactory.createUnit();
        }
        return table;
    }
}

