/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.impl.NTripleWriter;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.NoWriterForLangException;
import com.hp.hpl.jena.xmloutput.impl.Abbreviated;
import com.hp.hpl.jena.xmloutput.impl.Basic;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;

public class testWriterInterface
extends ModelTestBase {
    private String lang;

    public testWriterInterface(String name, String lang) {
        super(name);
        this.lang = lang;
    }

    public void testLineSeparator() {
        String newline = System.getProperty("line.separator");
        String newline_XMLNS = newline + "    xmlns";
        Model m = testWriterInterface.modelWithStatements("http://eh/spoo thingies something");
        m.setNsPrefix("eh", "http://eh/");
        StringWriter sos = new StringWriter();
        m.write(sos);
        testWriterInterface.assertTrue((sos.toString().indexOf(newline_XMLNS) > -1 ? (byte)1 : 0) != 0);
    }

    public void testInterface() {
        Model m1 = testWriterInterface.createMemModel();
        testWriterInterface.assertTrue((String)"Default writer should be Basic.", (boolean)(m1.getWriter() instanceof Basic));
        testWriterInterface.assertTrue((String)"RDF/XML writer should be Basic.", (boolean)(m1.getWriter() instanceof Basic));
        testWriterInterface.assertTrue((String)"RDF/XML-ABBREV writer should be Abbreviated.", (boolean)(m1.getWriter("RDF/XML-ABBREV") instanceof Abbreviated));
        testWriterInterface.assertTrue((String)"N-TRIPLE writer should be NTripleWriter.", (boolean)(m1.getWriter("N-TRIPLE") instanceof NTripleWriter));
    }

    public void testNoWriter() {
        Model m1 = testWriterInterface.createMemModel();
        try {
            m1.setWriterClassName("foobar", "");
            m1.getWriter("foobar");
            testWriterInterface.fail((String)"Missing Writer undetected.");
        }
        catch (NoWriterForLangException noWriterForLangException) {
            // empty catch block
        }
    }

    public void testAnotherWriter() {
        Model m1 = testWriterInterface.createMemModel();
        m1.setWriterClassName("foobar", "com.hp.hpl.jena.xmloutput.impl.Basic");
        testWriterInterface.assertTrue((String)"Failed to access set writer", (boolean)(m1.getWriter("foobar") instanceof Basic));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriting() {
        ByteArrayOutputStream output = null;
        Model m1 = testWriterInterface.createMemModel();
        try {
            ByteArrayOutputStream out;
            output = out = new ByteArrayOutputStream();
            m1.write(output, this.lang);
            out.reset();
            ((OutputStream)output).close();
        }
        catch (Exception e2) {
            testWriterInterface.fail((String)e2.getMessage());
        }
        finally {
            if (output != null) {
                try {
                    ((OutputStream)output).close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

