/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimerTask;
import java.util.TreeMap;
import org.apache.commons.pool.BaseKeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class GenericKeyedObjectPool
extends BaseKeyedObjectPool
implements KeyedObjectPool {
    public static final byte WHEN_EXHAUSTED_FAIL = 0;
    public static final byte WHEN_EXHAUSTED_BLOCK = 1;
    public static final byte WHEN_EXHAUSTED_GROW = 2;
    public static final int DEFAULT_MAX_IDLE = 8;
    public static final int DEFAULT_MAX_ACTIVE = 8;
    public static final int DEFAULT_MAX_TOTAL = -1;
    public static final byte DEFAULT_WHEN_EXHAUSTED_ACTION = 1;
    public static final long DEFAULT_MAX_WAIT = -1L;
    public static final boolean DEFAULT_TEST_ON_BORROW = false;
    public static final boolean DEFAULT_TEST_ON_RETURN = false;
    public static final boolean DEFAULT_TEST_WHILE_IDLE = false;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = -1L;
    public static final int DEFAULT_NUM_TESTS_PER_EVICTION_RUN = 3;
    public static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 1800000L;
    public static final int DEFAULT_MIN_IDLE = 0;
    private int _maxIdle = 8;
    private int _minIdle = 0;
    private int _maxActive = 8;
    private int _maxTotal = -1;
    private long _maxWait = -1L;
    private byte _whenExhaustedAction = 1;
    private boolean _testOnBorrow = false;
    private boolean _testOnReturn = false;
    private boolean _testWhileIdle = false;
    private long _timeBetweenEvictionRunsMillis = -1L;
    private int _numTestsPerEvictionRun = 3;
    private long _minEvictableIdleTimeMillis = 1800000L;
    private HashMap _poolMap = null;
    private HashMap _activeMap = null;
    private int _totalActive = 0;
    private int _totalIdle = 0;
    private KeyedPoolableObjectFactory _factory = null;
    private Evictor _evictor = null;
    private Set _recentlyEvictedKeys = null;
    private int _evictLastIndex = -1;

    public GenericKeyedObjectPool() {
        this(null, 8, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory) {
        this(factory, 8, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, Config config) {
        this(factory, config.maxActive, config.whenExhaustedAction, config.maxWait, config.maxIdle, config.maxTotal, config.testOnBorrow, config.testOnReturn, config.timeBetweenEvictionRunsMillis, config.numTestsPerEvictionRun, config.minEvictableIdleTimeMillis, config.testWhileIdle);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive) {
        this(factory, maxActive, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait) {
        this(factory, maxActive, whenExhaustedAction, maxWait, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, boolean testOnBorrow, boolean testOnReturn) {
        this(factory, maxActive, whenExhaustedAction, maxWait, 8, testOnBorrow, testOnReturn, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, boolean testOnBorrow, boolean testOnReturn) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, testOnBorrow, testOnReturn, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, -1, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, int maxTotal, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, maxTotal, 0, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, int maxTotal, int minIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle) {
        this._factory = factory;
        this._maxActive = maxActive;
        switch (whenExhaustedAction) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = whenExhaustedAction;
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + whenExhaustedAction + " not recognized.");
            }
        }
        this._maxWait = maxWait;
        this._maxIdle = maxIdle;
        this._maxTotal = maxTotal;
        this._minIdle = minIdle;
        this._testOnBorrow = testOnBorrow;
        this._testOnReturn = testOnReturn;
        this._timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this._numTestsPerEvictionRun = numTestsPerEvictionRun;
        this._minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        this._testWhileIdle = testWhileIdle;
        this._poolMap = new HashMap();
        this._activeMap = new HashMap();
        this.startEvictor(this._timeBetweenEvictionRunsMillis);
    }

    public synchronized int getMaxActive() {
        return this._maxActive;
    }

    public synchronized void setMaxActive(int maxActive) {
        this._maxActive = maxActive;
        this.notifyAll();
    }

    public synchronized int getMaxTotal() {
        return this._maxTotal;
    }

    public synchronized void setMaxTotal(int maxTotal) {
        this._maxTotal = maxTotal;
        this.notifyAll();
    }

    public synchronized byte getWhenExhaustedAction() {
        return this._whenExhaustedAction;
    }

    public synchronized void setWhenExhaustedAction(byte whenExhaustedAction) {
        switch (whenExhaustedAction) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = whenExhaustedAction;
                this.notifyAll();
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + whenExhaustedAction + " not recognized.");
            }
        }
    }

    public synchronized long getMaxWait() {
        return this._maxWait;
    }

    public synchronized void setMaxWait(long maxWait) {
        this._maxWait = maxWait;
    }

    public synchronized int getMaxIdle() {
        return this._maxIdle;
    }

    public synchronized void setMaxIdle(int maxIdle) {
        this._maxIdle = maxIdle;
        this.notifyAll();
    }

    public synchronized void setMinIdle(int poolSize) {
        this._minIdle = poolSize;
    }

    public synchronized int getMinIdle() {
        return this._minIdle;
    }

    public synchronized boolean getTestOnBorrow() {
        return this._testOnBorrow;
    }

    public synchronized void setTestOnBorrow(boolean testOnBorrow) {
        this._testOnBorrow = testOnBorrow;
    }

    public synchronized boolean getTestOnReturn() {
        return this._testOnReturn;
    }

    public synchronized void setTestOnReturn(boolean testOnReturn) {
        this._testOnReturn = testOnReturn;
    }

    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this._timeBetweenEvictionRunsMillis;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this._timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this.startEvictor(this._timeBetweenEvictionRunsMillis);
    }

    public synchronized int getNumTestsPerEvictionRun() {
        return this._numTestsPerEvictionRun;
    }

    public synchronized void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this._numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this._minEvictableIdleTimeMillis;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this._minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public synchronized boolean getTestWhileIdle() {
        return this._testWhileIdle;
    }

    public synchronized void setTestWhileIdle(boolean testWhileIdle) {
        this._testWhileIdle = testWhileIdle;
    }

    public synchronized void setConfig(Config conf) {
        this.setMaxIdle(conf.maxIdle);
        this.setMaxActive(conf.maxActive);
        this.setMaxTotal(conf.maxTotal);
        this.setMinIdle(conf.minIdle);
        this.setMaxWait(conf.maxWait);
        this.setWhenExhaustedAction(conf.whenExhaustedAction);
        this.setTestOnBorrow(conf.testOnBorrow);
        this.setTestOnReturn(conf.testOnReturn);
        this.setTestWhileIdle(conf.testWhileIdle);
        this.setNumTestsPerEvictionRun(conf.numTestsPerEvictionRun);
        this.setMinEvictableIdleTimeMillis(conf.minEvictableIdleTimeMillis);
        this.setTimeBetweenEvictionRunsMillis(conf.timeBetweenEvictionRunsMillis);
    }

    public synchronized Object borrowObject(Object key) throws Exception {
        ObjectTimestampPair pair;
        block19: {
            long starttime = System.currentTimeMillis();
            boolean newlyCreated = false;
            block9: while (true) {
                LinkedList pool;
                if (null == (pool = (LinkedList)this._poolMap.get(key))) {
                    pool = new LinkedList();
                    this._poolMap.put(key, pool);
                }
                pair = null;
                try {
                    pair = (ObjectTimestampPair)pool.removeFirst();
                    if (null != pair) {
                        --this._totalIdle;
                    }
                }
                catch (NoSuchElementException e2) {
                    // empty catch block
                }
                if (null == pair) {
                    Object obj;
                    if (this._maxTotal > 0 && this._totalActive + this._totalIdle >= this._maxTotal) {
                        this.clearOldest();
                    }
                    int active = this.getActiveCount(key);
                    if (!(this._maxActive >= 0 && active >= this._maxActive || this._maxTotal >= 0 && this._totalActive + this._totalIdle >= this._maxTotal)) {
                        obj = this._factory.makeObject(key);
                        pair = new ObjectTimestampPair(obj);
                        newlyCreated = true;
                    } else {
                        switch (this._whenExhaustedAction) {
                            case 2: {
                                obj = this._factory.makeObject(key);
                                pair = new ObjectTimestampPair(obj);
                                break;
                            }
                            case 0: {
                                throw new NoSuchElementException();
                            }
                            case 1: {
                                try {
                                    if (this._maxWait <= 0L) {
                                        this.wait();
                                    } else {
                                        long elapsed = System.currentTimeMillis() - starttime;
                                        long waitTime = this._maxWait - elapsed;
                                        if (waitTime > 0L) {
                                            this.wait(waitTime);
                                        }
                                    }
                                }
                                catch (InterruptedException e3) {
                                    // empty catch block
                                }
                                if (this._maxWait <= 0L || System.currentTimeMillis() - starttime < this._maxWait) continue block9;
                                throw new NoSuchElementException("Timeout waiting for idle object");
                            }
                            default: {
                                throw new IllegalArgumentException("whenExhaustedAction " + this._whenExhaustedAction + " not recognized.");
                            }
                        }
                    }
                }
                this._factory.activateObject(key, pair.value);
                if (!this._testOnBorrow || this._factory.validateObject(key, pair.value)) break block19;
                this._factory.destroyObject(key, pair.value);
                if (newlyCreated) break;
            }
            throw new NoSuchElementException("Could not create a validated object");
        }
        this.incrementActiveCount(key);
        return pair.value;
    }

    public synchronized void clear() {
        Iterator keyiter = this._poolMap.keySet().iterator();
        while (keyiter.hasNext()) {
            Object key = keyiter.next();
            LinkedList list = (LinkedList)this._poolMap.get(key);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                try {
                    this._factory.destroyObject(key, ((ObjectTimestampPair)it.next()).value);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                it.remove();
            }
        }
        this._poolMap.clear();
        if (this._recentlyEvictedKeys != null) {
            this._recentlyEvictedKeys.clear();
        }
        this._totalIdle = 0;
        this.notifyAll();
    }

    public synchronized void clearOldest() {
        TreeMap map = new TreeMap();
        Iterator keyiter = this._poolMap.keySet().iterator();
        while (keyiter.hasNext()) {
            Object key = keyiter.next();
            LinkedList list = (LinkedList)this._poolMap.get(key);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                ObjectTimestampPair pair = (ObjectTimestampPair)it.next();
                map.put(pair, key);
            }
        }
        Set setPairKeys = map.entrySet();
        Iterator iter = setPairKeys.iterator();
        for (int itemsToRemove = (int)((double)map.size() * 0.15) + 1; iter.hasNext() && itemsToRemove > 0; --itemsToRemove) {
            Map.Entry entry = iter.next();
            Object key = entry.getValue();
            ObjectTimestampPair pairTimeStamp = (ObjectTimestampPair)entry.getKey();
            LinkedList list = (LinkedList)this._poolMap.get(key);
            list.remove(pairTimeStamp);
            try {
                this._factory.destroyObject(key, pairTimeStamp.value);
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (list.isEmpty()) {
                this._poolMap.remove(key);
            }
            --this._totalIdle;
        }
        this.notifyAll();
    }

    public synchronized void clear(Object key) {
        LinkedList pool = (LinkedList)this._poolMap.remove(key);
        if (null == pool) {
            return;
        }
        Iterator it = pool.iterator();
        while (it.hasNext()) {
            try {
                this._factory.destroyObject(key, ((ObjectTimestampPair)it.next()).value);
            }
            catch (Exception e2) {
                // empty catch block
            }
            it.remove();
            --this._totalIdle;
        }
        this.notifyAll();
    }

    public synchronized int getNumActive() {
        return this._totalActive;
    }

    public synchronized int getNumIdle() {
        return this._totalIdle;
    }

    public synchronized int getNumActive(Object key) {
        return this.getActiveCount(key);
    }

    public synchronized int getNumIdle(Object key) {
        try {
            return ((LinkedList)this._poolMap.get(key)).size();
        }
        catch (Exception e2) {
            return 0;
        }
    }

    public synchronized void returnObject(Object key, Object obj) throws Exception {
        boolean success = true;
        if (this._testOnReturn && !this._factory.validateObject(key, obj)) {
            success = false;
            try {
                this._factory.destroyObject(key, obj);
            }
            catch (Exception e2) {}
        } else {
            try {
                this._factory.passivateObject(key, obj);
            }
            catch (Exception e3) {
                success = false;
            }
        }
        boolean shouldDestroy = false;
        LinkedList<ObjectTimestampPair> pool = (LinkedList<ObjectTimestampPair>)this._poolMap.get(key);
        if (null == pool) {
            pool = new LinkedList<ObjectTimestampPair>();
            this._poolMap.put(key, pool);
        }
        this.decrementActiveCount(key);
        if (this._maxIdle >= 0 && pool.size() >= this._maxIdle) {
            shouldDestroy = true;
        } else if (success) {
            pool.addLast(new ObjectTimestampPair(obj));
            ++this._totalIdle;
        }
        this.notifyAll();
        if (shouldDestroy) {
            try {
                this._factory.destroyObject(key, obj);
            }
            catch (Exception e4) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void invalidateObject(Object key, Object obj) throws Exception {
        try {
            this._factory.destroyObject(key, obj);
        }
        finally {
            this.decrementActiveCount(key);
            this.notifyAll();
        }
    }

    public synchronized void addObject(Object key) throws Exception {
        Object obj = this._factory.makeObject(key);
        this.incrementActiveCount(key);
        this.returnObject(key, obj);
    }

    public synchronized void preparePool(Object key, boolean populateImmediately) {
        LinkedList pool = (LinkedList)this._poolMap.get(key);
        if (null == pool) {
            pool = new LinkedList();
            this._poolMap.put(key, pool);
        }
        if (populateImmediately) {
            try {
                this.ensureMinIdle(key);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
    }

    public synchronized void close() throws Exception {
        this.clear();
        this._poolMap = null;
        this._activeMap = null;
        this._recentlyEvictedKeys = null;
        if (null != this._evictor) {
            this._evictor.cancel();
            this._evictor = null;
        }
    }

    public synchronized void setFactory(KeyedPoolableObjectFactory factory) throws IllegalStateException {
        if (0 < this.getNumActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = factory;
    }

    public synchronized void evict() throws Exception {
        Object key = null;
        if (this._recentlyEvictedKeys == null) {
            this._recentlyEvictedKeys = new HashSet(this._poolMap.size());
        }
        HashSet remainingKeys = new HashSet(this._poolMap.keySet());
        remainingKeys.removeAll(this._recentlyEvictedKeys);
        Iterator keyIter = remainingKeys.iterator();
        ListIterator objIter = null;
        int m = this.getNumTests();
        for (int i = 0; i < m; ++i) {
            if (this._poolMap.size() <= 0) continue;
            if (key == null) {
                if (!keyIter.hasNext()) {
                    this._recentlyEvictedKeys.clear();
                    remainingKeys = new HashSet(this._poolMap.keySet());
                    keyIter = remainingKeys.iterator();
                }
                if (!keyIter.hasNext()) {
                    return;
                }
                key = keyIter.next();
            }
            if (objIter == null) {
                LinkedList list = (LinkedList)this._poolMap.get(key);
                if (this._evictLastIndex < 0 || this._evictLastIndex > list.size()) {
                    this._evictLastIndex = list.size();
                }
                objIter = list.listIterator(this._evictLastIndex);
            }
            if (objIter.hasPrevious()) {
                ObjectTimestampPair pair = (ObjectTimestampPair)objIter.previous();
                boolean removeObject = false;
                if (this._minEvictableIdleTimeMillis > 0L && System.currentTimeMillis() - pair.tstamp > this._minEvictableIdleTimeMillis) {
                    removeObject = true;
                }
                if (this._testWhileIdle && !removeObject) {
                    boolean active = false;
                    try {
                        this._factory.activateObject(key, pair.value);
                        active = true;
                    }
                    catch (Exception e2) {
                        removeObject = true;
                    }
                    if (active) {
                        if (!this._factory.validateObject(key, pair.value)) {
                            removeObject = true;
                        } else {
                            try {
                                this._factory.passivateObject(key, pair.value);
                            }
                            catch (Exception e3) {
                                removeObject = true;
                            }
                        }
                    }
                }
                if (!removeObject) continue;
                try {
                    objIter.remove();
                    --this._totalIdle;
                    this._factory.destroyObject(key, pair.value);
                    if (this._minIdle != 0 || !((LinkedList)this._poolMap.get(key)).isEmpty()) continue;
                    this._poolMap.remove(key);
                }
                catch (Exception e4) {}
                continue;
            }
            this._recentlyEvictedKeys.add(key);
            this._evictLastIndex = -1;
            objIter = null;
        }
    }

    private synchronized void ensureMinIdle() throws Exception {
        Iterator iterator = this._poolMap.keySet().iterator();
        if (this._minIdle > 0) {
            while (iterator.hasNext()) {
                Object key = iterator.next();
                this.ensureMinIdle(key);
            }
        }
    }

    private synchronized void ensureMinIdle(Object key) throws Exception {
        int numberToCreate = this.calculateDefecit(key);
        for (int i = 0; i < numberToCreate; ++i) {
            this.addObject(key);
        }
    }

    protected synchronized void startEvictor(long delay) {
        if (null != this._evictor) {
            this._evictor.cancel();
            this._evictor = null;
        }
        if (delay > 0L) {
            this._evictor = new Evictor();
            GenericObjectPool.EVICTION_TIMER.schedule((TimerTask)this._evictor, delay, delay);
        }
    }

    synchronized String debugInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append("Active: ").append(this.getNumActive()).append("\n");
        buf.append("Idle: ").append(this.getNumIdle()).append("\n");
        Iterator it = this._poolMap.keySet().iterator();
        while (it.hasNext()) {
            buf.append("\t").append(this._poolMap.get(it.next())).append("\n");
        }
        return buf.toString();
    }

    private int getNumTests() {
        if (this._numTestsPerEvictionRun >= 0) {
            return this._numTestsPerEvictionRun;
        }
        return (int)Math.ceil((double)this._totalIdle / Math.abs((double)this._numTestsPerEvictionRun));
    }

    private void incrementActiveCount(Object key) {
        ++this._totalActive;
        Integer active = (Integer)this._activeMap.get(key);
        if (null == active) {
            this._activeMap.put(key, new Integer(1));
        } else {
            this._activeMap.put(key, new Integer(active + 1));
        }
    }

    private void decrementActiveCount(Object key) {
        --this._totalActive;
        Integer active = (Integer)this._activeMap.get(key);
        if (null != active) {
            if (active <= 1) {
                this._activeMap.remove(key);
            } else {
                this._activeMap.put(key, new Integer(active - 1));
            }
        }
    }

    private int getActiveCount(Object key) {
        int active = 0;
        Integer act = (Integer)this._activeMap.get(key);
        if (null != act) {
            active = act;
        }
        return active;
    }

    private int calculateDefecit(Object key) {
        int growLimit;
        int objectDefecit = 0;
        objectDefecit = this.getMinIdle() - this.getNumIdle(key);
        if (this.getMaxActive() > 0) {
            growLimit = Math.max(0, this.getMaxActive() - this.getNumActive(key) - this.getNumIdle(key));
            objectDefecit = Math.min(objectDefecit, growLimit);
        }
        if (this.getMaxTotal() > 0) {
            growLimit = Math.max(0, this.getMaxTotal() - this.getNumActive() - this.getNumIdle());
            objectDefecit = Math.min(objectDefecit, growLimit);
        }
        return objectDefecit;
    }

    public static class Config {
        public int maxIdle = 8;
        public int maxActive = 8;
        public int maxTotal = -1;
        public int minIdle = 0;
        public long maxWait = -1L;
        public byte whenExhaustedAction = 1;
        public boolean testOnBorrow = false;
        public boolean testOnReturn = false;
        public boolean testWhileIdle = false;
        public long timeBetweenEvictionRunsMillis = -1L;
        public int numTestsPerEvictionRun = 3;
        public long minEvictableIdleTimeMillis = 1800000L;
    }

    private class Evictor
    extends TimerTask {
        private Evictor() {
        }

        public void run() {
            try {
                GenericKeyedObjectPool.this.evict();
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                GenericKeyedObjectPool.this.ensureMinIdle();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class ObjectTimestampPair
    implements Comparable {
        Object value;
        long tstamp;

        ObjectTimestampPair(Object val) {
            this(val, System.currentTimeMillis());
        }

        ObjectTimestampPair(Object val, long time) {
            this.value = val;
            this.tstamp = time;
        }

        public String toString() {
            return this.value + ";" + this.tstamp;
        }

        public int compareTo(Object obj) {
            return this.compareTo((ObjectTimestampPair)obj);
        }

        public int compareTo(ObjectTimestampPair other) {
            return (int)(this.tstamp - other.tstamp);
        }
    }
}

