/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Node_Variable;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.system.JenaSystem;

public class Var
extends Node_Variable {
    public static Var ANON;
    private final int hashCodeValue = super.hashCode();

    public static Var alloc(String varName) {
        return new Var(varName);
    }

    public static Var alloc(Node_Variable v) {
        if (v instanceof Var) {
            return (Var)v;
        }
        return new Var(v);
    }

    public static Var alloc(Node v) {
        if (v instanceof Var) {
            return (Var)v;
        }
        if (v instanceof Node_Variable) {
            return new Var((Node_Variable)v);
        }
        throw new NotAVariableException("Node: " + v);
    }

    public static Var alloc(Var v) {
        return v;
    }

    public static Var alloc(ExprVar nv) {
        return new Var(nv);
    }

    public static Node lookup(Binding binding, Node node) {
        if (!Var.isVar(node)) {
            return node;
        }
        Var var = Var.alloc(node);
        return Var.lookup(binding, var);
    }

    public static Node lookup(Binding binding, Var var) {
        Node n = binding.get(var);
        if (n != null) {
            return n;
        }
        return var;
    }

    private Var(String varName) {
        super(varName);
    }

    private Var(Node_Variable v) {
        this(v.getName());
    }

    private Var(ExprVar v) {
        this(v.getVarName());
    }

    public Node asNode() {
        return this;
    }

    public String getVarName() {
        return this.getName();
    }

    @Override
    public final int hashCode() {
        return this.hashCodeValue;
    }

    @Override
    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Var)) {
            return false;
        }
        return super.equals(other);
    }

    public boolean isNamedVar() {
        return Var.isNamedVarName(this.getName());
    }

    public boolean isBlankNodeVar() {
        return Var.isBlankNodeVarName(this.getName());
    }

    public boolean isAllocVar() {
        return Var.isAllocVarName(this.getName());
    }

    public boolean isAnonVar() {
        return Var.isAnonVar(this);
    }

    public static String canonical(String x) {
        if (x.startsWith("?")) {
            return x.substring(1);
        }
        if (x.startsWith("$")) {
            return x.substring(1);
        }
        return x;
    }

    public static boolean isVar(Node node) {
        if (node instanceof Var) {
            return true;
        }
        if (node != null && node.isVariable()) {
            throw new NotAVariableException("Node_Variable (not a Var) found");
        }
        return false;
    }

    public static boolean isRenamedVar(Node node) {
        return node.isVariable() && Var.isRenamedVar(node.getName());
    }

    public static boolean isRenamedVar(String x) {
        return x.startsWith("/");
    }

    public static boolean isNamedVar(Node node) {
        return node.isVariable() && Var.isNamedVarName(node.getName());
    }

    public static boolean isNamedVarName(String x) {
        return !Var.isBlankNodeVarName(x) && !Var.isAllocVarName(x);
    }

    public static boolean isBlankNodeVar(Node node) {
        return node.isVariable() && Var.isBlankNodeVarName(node.getName());
    }

    public static boolean isBlankNodeVarName(String x) {
        return x.startsWith("?");
    }

    public static boolean isAllocVar(Node node) {
        return node.isVariable() && Var.isAllocVarName(node.getName());
    }

    public static boolean isAllocVarName(String x) {
        return x.startsWith(".");
    }

    public static List<Var> varList(Collection<String> varNames) {
        ArrayList<Var> x = new ArrayList<Var>();
        for (String obj : varNames) {
            x.add(Var.alloc(obj));
        }
        return x;
    }

    public static boolean isAnonVar(Var var) {
        return var == ANON;
    }

    public static List<String> varNames(Collection<Var> vars) {
        ArrayList<String> x = new ArrayList<String>();
        for (Var var : vars) {
            x.add(var.getVarName());
        }
        return x;
    }

    static {
        JenaSystem.init();
        ANON = new Var("?_");
    }

    static class NotAVariableException
    extends ARQInternalErrorException {
        NotAVariableException(String msg) {
            super(msg);
        }
    }
}

