/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.path;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.PathBlock;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarAlloc;
import org.apache.jena.sparql.path.P_FixedLength;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Mod;
import org.apache.jena.sparql.path.P_Seq;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathFactory;

public class PathCompiler {
    private static VarAlloc varAlloc = new VarAlloc("?P");

    public PathBlock reduce(PathBlock pathBlock) {
        PathBlock x = new PathBlock();
        this.reduce(x, pathBlock, varAlloc);
        return x;
    }

    void reduce(PathBlock x, PathBlock pathBlock, VarAlloc varAlloc) {
        for (TriplePath tp : pathBlock) {
            if (tp.isTriple()) {
                x.add(tp);
                continue;
            }
            PathCompiler.reduce(x, varAlloc, tp.getSubject(), tp.getPath(), tp.getObject());
        }
    }

    public PathBlock reduce(TriplePath triplePath) {
        PathBlock x = new PathBlock();
        PathCompiler.reduce(x, varAlloc, triplePath.getSubject(), triplePath.getPath(), triplePath.getObject());
        return x;
    }

    public PathBlock reduce(Node start, Path path, Node finish) {
        PathBlock x = new PathBlock();
        PathCompiler.reduce(x, varAlloc, start, path, finish);
        return x;
    }

    private static void reduce(PathBlock x, VarAlloc varAlloc, Node startNode, Path path, Node endNode) {
        P_FixedLength pFixed;
        long N;
        if (path instanceof P_Link) {
            Node pred = ((P_Link)path).getNode();
            Triple t = new Triple(startNode, pred, endNode);
            x.add(new TriplePath(t));
            return;
        }
        if (path instanceof P_Seq) {
            P_Seq ps = (P_Seq)path;
            Var v = varAlloc.allocVar();
            PathCompiler.reduce(x, varAlloc, startNode, ps.getLeft(), v);
            PathCompiler.reduce(x, varAlloc, v, ps.getRight(), endNode);
            return;
        }
        if (path instanceof P_Inverse) {
            PathCompiler.reduce(x, varAlloc, endNode, ((P_Inverse)path).getSubPath(), startNode);
            return;
        }
        if (path instanceof P_FixedLength && (N = (pFixed = (P_FixedLength)path).getCount()) > 0L) {
            Node stepStart = startNode;
            for (long i = 0L; i < N - 1L; ++i) {
                Var v = varAlloc.allocVar();
                PathCompiler.reduce(x, varAlloc, stepStart, pFixed.getSubPath(), v);
                stepStart = v;
            }
            PathCompiler.reduce(x, varAlloc, stepStart, pFixed.getSubPath(), endNode);
            return;
        }
        if (path instanceof P_Mod) {
            P_Mod pMod = (P_Mod)path;
            if (pMod.isFixedLength() && pMod.getFixedLength() > 0L && (N = pMod.getFixedLength()) > 0L) {
                Node stepStart = startNode;
                for (long i = 0L; i < N - 1L; ++i) {
                    Var v = varAlloc.allocVar();
                    PathCompiler.reduce(x, varAlloc, stepStart, pMod.getSubPath(), v);
                    stepStart = v;
                }
                PathCompiler.reduce(x, varAlloc, stepStart, pMod.getSubPath(), endNode);
                return;
            }
            if (pMod.getMin() > 0L) {
                Path p2;
                Path p1 = PathFactory.pathFixedLength(pMod.getSubPath(), pMod.getMin());
                if (pMod.getMax() < 0L) {
                    p2 = PathFactory.pathZeroOrMoreN(pMod.getSubPath());
                } else {
                    long len2 = pMod.getMax() - pMod.getMin();
                    if (len2 < 0L) {
                        len2 = 0L;
                    }
                    p2 = PathFactory.pathMod(pMod.getSubPath(), 0L, len2);
                }
                Var v = varAlloc.allocVar();
                if (!startNode.isVariable() || endNode.isVariable()) {
                    PathCompiler.reduce(x, varAlloc, startNode, p1, v);
                    PathCompiler.reduce(x, varAlloc, v, p2, endNode);
                } else {
                    PathCompiler.reduce(x, varAlloc, v, p2, endNode);
                    PathCompiler.reduce(x, varAlloc, startNode, p1, v);
                }
                return;
            }
        }
        x.add(new TriplePath(startNode, path, endNode));
    }
}

