/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.Map;
import java.util.Stack;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.InFixToPostFix;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.rule.RuleFactory;
import org.apache.log4j.spi.LoggingEvent;

public class ExpressionRule
extends AbstractRule {
    static final long serialVersionUID = 5809121703146893729L;
    private static final InFixToPostFix CONVERTER = new InFixToPostFix();
    private static final PostFixExpressionCompiler COMPILER = new PostFixExpressionCompiler();
    private final Rule rule;

    private ExpressionRule(Rule r) {
        this.rule = r;
    }

    public static Rule getRule(String expression) {
        return ExpressionRule.getRule(expression, false);
    }

    public static Rule getRule(String expression, boolean isPostFix) {
        String postFix = expression;
        if (!isPostFix) {
            postFix = CONVERTER.convert(expression);
        }
        return new ExpressionRule(COMPILER.compileExpression(postFix));
    }

    public boolean evaluate(LoggingEvent event, Map matches2) {
        return this.rule.evaluate(event, matches2);
    }

    public String toString() {
        return this.rule.toString();
    }

    static final class PostFixExpressionCompiler {
        PostFixExpressionCompiler() {
        }

        public Rule compileExpression(String expression) {
            RuleFactory factory = RuleFactory.getInstance();
            Stack<Object> stack = new Stack<Object>();
            InFixToPostFix.CustomTokenizer tokenizer = new InFixToPostFix.CustomTokenizer(expression);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.startsWith("'") || token.startsWith("\"")) {
                    String quoteChar = token.substring(0, 1);
                    token = token.substring(1);
                    while (!token.endsWith(quoteChar) && tokenizer.hasMoreTokens()) {
                        token = token + " " + tokenizer.nextToken();
                    }
                    if (token.length() > 0) {
                        token = token.substring(0, token.length() - 1);
                    }
                } else if (factory.isRule(token)) {
                    Rule r = factory.getRule(token, stack);
                    stack.push(r);
                    token = null;
                }
                if (token == null || token.length() <= 0) continue;
                stack.push(token);
            }
            if (stack.size() == 1 && !(stack.peek() instanceof Rule)) {
                Object o = stack.pop();
                stack.push("MSG");
                stack.push(o);
                return factory.getRule("~=", stack);
            }
            if (stack.size() != 1 || !(stack.peek() instanceof Rule)) {
                throw new IllegalArgumentException("invalid expression: " + expression);
            }
            return (Rule)stack.pop();
        }
    }
}

