/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.index.generator;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMap;
import org.apache.log4j.Logger;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.index.generator.IndexTaskGenerator;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;
import org.springframework.beans.factory.annotation.Autowired;

public class IndexTaskGeneratorEntryListener
implements EntryListener<Identifier, SystemMetadata> {
    private static Logger logger = Logger.getLogger(IndexTaskGeneratorEntryListener.class.getName());
    @Autowired
    private IndexTaskGenerator generator;
    private IMap<Identifier, SystemMetadata> systemMetadata;
    private IMap<Identifier, String> objectPaths;

    public void start() {
        logger.info("starting index task generator entry listener...");
        this.systemMetadata = HazelcastClientFactory.getSystemMetadataMap();
        this.objectPaths = HazelcastClientFactory.getObjectPathMap();
        this.systemMetadata.addEntryListener(this, true);
        logger.info("System Metadata size: " + this.systemMetadata.size());
        logger.info("Object path size:" + this.objectPaths.size());
    }

    public void stop() {
        logger.info("stopping index task generator entry listener...");
        this.systemMetadata.removeEntryListener(this);
        try {
            this.generator.close();
        }
        catch (Exception e2) {
            logger.warn("IndexTaskGeneratorDaemon.stop - there was an issue to close the index generator since " + e2.getMessage());
        }
    }

    @Override
    public void entryUpdated(EntryEvent<Identifier, SystemMetadata> event) {
        logger.info("UPDATE EVENT - index task generator - system metadata callback invoked on pid: " + event.getKey().getValue());
        this.generator.processSystemMetaDataUpdate(event.getValue(), this.getObjectPath(event));
    }

    @Override
    public void entryAdded(EntryEvent<Identifier, SystemMetadata> event) {
        if (event.getKey() != null && event.getValue() != null) {
            logger.info("ADD EVENT - index task generator - system metadata callback invoked on pid: " + event.getKey().getValue());
            SystemMetadata smd = event.getValue();
            if (smd.getSerialVersion().longValue() > 1L) {
                logger.warn("Add event for pid: " + event.getKey().getValue() + " determined to be invalid due to serial version: " + smd.getSerialVersion().longValue() + ".  skipping add index task.");
            } else {
                logger.info("Processing add event index task for pid: " + event.getKey().getValue());
                this.generator.processSystemMetaDataAdd(event.getValue(), this.getObjectPath(event));
            }
        }
    }

    private String getObjectPath(EntryEvent<Identifier, SystemMetadata> event) {
        return this.objectPaths.get(event.getKey());
    }

    @Override
    public void entryEvicted(EntryEvent<Identifier, SystemMetadata> arg0) {
    }

    @Override
    public void entryRemoved(EntryEvent<Identifier, SystemMetadata> event) {
        logger.info("REMOVE EVENT - index task generator - system metadata callback invoked on pid: " + event.getKey().getValue());
        this.generator.processSystemMetaDataDelete(event.getValue());
    }
}

