/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.annotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.ontology.OntDocumentManager;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.log4j.Logger;
import org.dataone.cn.indexer.annotation.SparqlField;
import org.dataone.cn.indexer.parser.ISolrDataField;

public class OntologyModelService {
    private static Logger log = Logger.getLogger(OntologyModelService.class);
    private static OntologyModelService instance = null;
    private static OntModel ontModel = null;
    public static final String FIELD_ANNOTATION = "sem_annotation";
    private static List<ISolrDataField> fieldList = new ArrayList<ISolrDataField>();
    private static List<String> ontologyList = new ArrayList<String>();
    private static Map<String, String> altEntryList = new HashMap<String, String>();

    private OntologyModelService() {
    }

    public static OntologyModelService getInstance() {
        if (instance == null) {
            instance = new OntologyModelService();
            instance.init();
        }
        return instance;
    }

    private void init() {
        log.debug(OntologyModelService.class.getName() + " init() called");
        if (ontModel != null) {
            return;
        }
        ontModel = ModelFactory.createOntologyModel();
        this.loadAltEntries();
        for (String ontologyUri : ontologyList) {
            try {
                log.debug("Loading ontology " + ontologyUri);
                ontModel.read(ontologyUri);
            }
            catch (Exception e2) {
                log.debug("Failed to read " + ontologyUri);
                e2.printStackTrace();
            }
        }
    }

    protected Map<String, Set<String>> expandConcepts(String uri) {
        log.debug("expandConcepts " + uri);
        HashMap<String, Set<String>> conceptFields = new HashMap<String, Set<String>>();
        if (uri == null || uri.length() < 1) {
            log.debug("Expansion failed because uri " + uri + " was either null or non-zero length.");
            return conceptFields;
        }
        log.debug("About to run through fieldList which is size " + fieldList.size());
        try {
            for (ISolrDataField field : fieldList) {
                String q = null;
                if (!(field instanceof SparqlField)) continue;
                q = ((SparqlField)field).getQuery();
                q = q.replaceAll("\\$CONCEPT_URI", uri);
                log.debug("SPARQL Query" + q.toString());
                Query query2 = QueryFactory.create(q);
                QueryExecution qexec = QueryExecutionFactory.create(query2, (Model)ontModel);
                ResultSet results = qexec.execSelect();
                String name = field.getName();
                HashSet<String> values = new HashSet<String>();
                while (results.hasNext()) {
                    QuerySolution solution = results.next();
                    log.debug("Solution SPARQL result: " + solution.toString());
                    if (!solution.contains(name) || solution.get(field.getName()).isAnon()) continue;
                    String value = solution.get(name).toString();
                    log.debug("Adding value " + value);
                    values.add(value);
                }
                conceptFields.put(name, values);
            }
        }
        catch (QueryException ex) {
            log.error("OntologyModelService.expandConcepts(" + uri + ") encountered an exception while querying.");
        }
        return conceptFields;
    }

    public List<ISolrDataField> getFieldList() {
        return fieldList;
    }

    public void setFieldList(List<ISolrDataField> flds) {
        fieldList = flds;
    }

    private List<String> getOntologyList() {
        return ontologyList;
    }

    public void setOntologyList(List<String> ontlist) {
        ontologyList = ontlist;
    }

    public Map<String, String> getAltEntryList() {
        return altEntryList;
    }

    public void setAltEntryList(Map<String, String> entryList) {
        altEntryList = entryList;
    }

    public void loadAltEntries() {
        log.debug("OntologyModelService - Loading altEntries of size " + altEntryList.size());
        OntDocumentManager ontManager = ontModel.getDocumentManager();
        ontManager.setProcessImports(false);
        for (Map.Entry<String, String> entry : altEntryList.entrySet()) {
            ontManager.addAltEntry(entry.getKey(), entry.getValue());
        }
    }
}

